/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.KnnFloatVectorField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.VectorEncoding;
import org.neo4j.kernel.api.impl.schema.vector.VectorSimilarityFunction;
import org.neo4j.values.storable.FloatingPointArray;

class VectorDocumentStructure {
    static final String ENTITY_ID_KEY = "id";
    static final String VECTOR_VALUE_KEY = "vector";

    VectorDocumentStructure() {
    }

    static Term newTermForChangeOrRemove(long id) {
        return new Term(ENTITY_ID_KEY, Long.toString(id));
    }

    static Document createLuceneDocument(long id, FloatingPointArray value, VectorSimilarityFunction similarityFunction) {
        float[] vector = similarityFunction.maybeToValidVector(value);
        if (vector == null) {
            return null;
        }
        Document document = new Document();
        StringField idField = new StringField(ENTITY_ID_KEY, Long.toString(id), Field.Store.NO);
        NumericDocValuesField idValueField = new NumericDocValuesField(ENTITY_ID_KEY, id);
        document.add((IndexableField)idField);
        document.add((IndexableField)idValueField);
        VectorFieldType fieldType = new VectorFieldType(vector.length, similarityFunction);
        KnnFloatVectorField valueField = new KnnFloatVectorField(VECTOR_VALUE_KEY, vector, (FieldType)fieldType);
        document.add((IndexableField)valueField);
        return document;
    }

    private static class VectorFieldType
    extends FieldType {
        private final int vectorDimension;
        private final VectorSimilarityFunction similarityFunction;

        private VectorFieldType(int dimension, VectorSimilarityFunction similarityFunction) {
            this.vectorDimension = dimension;
            this.similarityFunction = similarityFunction;
            this.freeze();
        }

        public int vectorDimension() {
            return this.vectorDimension;
        }

        public org.apache.lucene.index.VectorSimilarityFunction vectorSimilarityFunction() {
            return this.similarityFunction.toLucene();
        }

        public VectorEncoding vectorEncoding() {
            return VectorEncoding.FLOAT32;
        }
    }
}

