/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import java.io.IOException;
import java.nio.file.OpenOption;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.AbstractLuceneIndexProvider;
import org.neo4j.kernel.api.impl.schema.LuceneIndexType;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexAccessor;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexBuilder;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexCapability;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexPopulator;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexReader;
import org.neo4j.kernel.api.impl.schema.vector.VectorSimilarityFunction;
import org.neo4j.kernel.api.impl.schema.vector.VectorUtils;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.values.storable.FloatingPointArray;
import org.neo4j.values.storable.Value;

public class VectorIndexProvider
extends AbstractLuceneIndexProvider {
    public static final IndexProviderDescriptor DESCRIPTOR = new IndexProviderDescriptor("vector", "1.0");
    private final FileSystemAbstraction fileSystem;

    public VectorIndexProvider(FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory, IndexDirectoryStructure.Factory directoryStructureFactory, Monitors monitors, Config config, DatabaseReadOnlyChecker readOnlyChecker) {
        super(IndexType.VECTOR, DESCRIPTOR, fileSystem, directoryFactory, directoryStructureFactory, monitors, config, readOnlyChecker);
        this.fileSystem = fileSystem;
    }

    @Override
    public void validatePrototype(IndexPrototype prototype) {
        super.validatePrototype(prototype);
        IndexConfig config = prototype.getIndexConfig();
        int dimensions = VectorUtils.vectorDimensionsFrom(config);
        if (dimensions < 1) {
            throw new IllegalArgumentException("Vector dimensionality must be a positive integer but was %d.".formatted(dimensions));
        }
        VectorUtils.vectorSimilarityFunctionFrom(config);
    }

    public IndexPopulator getPopulator(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker, TokenNameLookup tokenNameLookup, ImmutableSet<OpenOption> openOptions, StorageEngineIndexingBehaviour indexingBehaviour) {
        DatabaseIndex<VectorIndexReader> luceneIndex = ((VectorIndexBuilder)((VectorIndexBuilder)VectorIndexBuilder.create(descriptor, this.readOnlyChecker, this.config).withFileSystem(this.fileSystem)).withIndexStorage(this.getIndexStorage(descriptor.getId()))).withWriterConfig(() -> IndexWriterConfigs.population(LuceneIndexType.VECTOR, this.config)).build();
        if (luceneIndex.isReadOnly()) {
            throw new UnsupportedOperationException("Can't create populator for read only index");
        }
        IndexConfig indexConfig = descriptor.getIndexConfig();
        IgnoreStrategy ignoreStrategy = new IgnoreStrategy(VectorUtils.vectorDimensionsFrom(indexConfig));
        VectorSimilarityFunction similarityFunction = VectorUtils.vectorSimilarityFunctionFrom(indexConfig);
        return new VectorIndexPopulator(luceneIndex, ignoreStrategy, similarityFunction);
    }

    public IndexAccessor getOnlineAccessor(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup, ImmutableSet<OpenOption> openOptions, boolean readOnly, StorageEngineIndexingBehaviour indexingBehaviour) throws IOException {
        VectorIndexBuilder builder = (VectorIndexBuilder)VectorIndexBuilder.create(descriptor, this.readOnlyChecker, this.config).withIndexStorage(this.getIndexStorage(descriptor.getId()));
        if (readOnly) {
            builder = (VectorIndexBuilder)builder.permanentlyReadOnly();
        }
        DatabaseIndex<VectorIndexReader> luceneIndex = builder.build();
        luceneIndex.open();
        IndexConfig indexConfig = descriptor.getIndexConfig();
        IgnoreStrategy ignoreStrategy = new IgnoreStrategy(VectorUtils.vectorDimensionsFrom(indexConfig));
        VectorSimilarityFunction similarityFunction = VectorUtils.vectorSimilarityFunctionFrom(indexConfig);
        return new VectorIndexAccessor(luceneIndex, descriptor, ignoreStrategy, similarityFunction);
    }

    public IndexDescriptor completeConfiguration(IndexDescriptor index, StorageEngineIndexingBehaviour indexingBehaviour) {
        return index.getCapability().equals(IndexCapability.NO_CAPABILITY) ? index.withIndexCapability(VectorIndexProvider.capability(index.getIndexConfig())) : index;
    }

    public static IndexCapability capability(IndexConfig config) {
        return new VectorIndexCapability(config);
    }

    private record IgnoreStrategy(int dimensions) implements IndexUpdateIgnoreStrategy
    {
        public boolean ignore(Value[] values) {
            FloatingPointArray vector;
            Value value = values[0];
            return !(value instanceof FloatingPointArray && (vector = (FloatingPointArray)value).length() == this.dimensions);
        }
    }
}

