/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;

public abstract class LuceneIndexPopulatingUpdater
implements IndexUpdater {
    private final LuceneIndexWriter writer;
    private final IndexUpdateIgnoreStrategy ignoreStrategy;

    public LuceneIndexPopulatingUpdater(LuceneIndexWriter writer, IndexUpdateIgnoreStrategy ignoreStrategy) {
        this.writer = writer;
        this.ignoreStrategy = ignoreStrategy;
    }

    public void process(IndexEntryUpdate<?> update) {
        ValueIndexEntryUpdate<?> valueUpdate = this.asValueUpdate(update);
        if (valueUpdate == null) {
            return;
        }
        try {
            long entityId = valueUpdate.getEntityId();
            Object[] values = valueUpdate.values();
            UpdateMode updateMode = valueUpdate.updateMode();
            switch (updateMode) {
                case ADDED: {
                    this.added(valueUpdate);
                    this.writer.updateDocument(LuceneDocumentStructure.newTermForChangeOrRemove(entityId), LuceneDocumentStructure.documentRepresentingProperties(entityId, (Value[])values));
                    break;
                }
                case CHANGED: {
                    this.changed(valueUpdate);
                    this.writer.updateOrDeleteDocument(LuceneDocumentStructure.newTermForChangeOrRemove(entityId), LuceneDocumentStructure.documentRepresentingProperties(entityId, (Value[])values));
                    break;
                }
                case REMOVED: {
                    this.removed(valueUpdate);
                    this.writer.deleteDocuments(LuceneDocumentStructure.newTermForChangeOrRemove(entityId));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown update mode " + updateMode + " for values " + Arrays.toString(values));
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <INDEX_KEY extends SchemaDescriptorSupplier> ValueIndexEntryUpdate<INDEX_KEY> asValueUpdate(IndexEntryUpdate<INDEX_KEY> update) {
        ValueIndexEntryUpdate valueUpdate = super.asValueUpdate(update);
        return !this.ignoreStrategy.ignore(valueUpdate) ? this.ignoreStrategy.toEquivalentUpdate(valueUpdate) : null;
    }

    protected abstract void added(ValueIndexEntryUpdate<?> var1);

    protected abstract void changed(ValueIndexEntryUpdate<?> var1);

    protected abstract void removed(ValueIndexEntryUpdate<?> var1);
}

