/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.partition;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.impl.index.backup.LuceneIndexSnapshots;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.index.partition.Neo4jSearcherFactory;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;

public class ReadOnlyIndexPartition
extends AbstractIndexPartition {
    private final SearcherManager searcherManager;

    ReadOnlyIndexPartition(Path partitionFolder, Directory directory) throws IOException {
        super(partitionFolder, directory);
        this.searcherManager = new SearcherManager(directory, (SearcherFactory)new Neo4jSearcherFactory());
    }

    @Override
    public IndexWriter getIndexWriter() {
        throw new UnsupportedOperationException("Retrieving index writer from read only index partition is unsupported.");
    }

    @Override
    public PartitionSearcher acquireSearcher() throws IOException {
        return new PartitionSearcher((ReferenceManager<IndexSearcher>)this.searcherManager);
    }

    @Override
    public void maybeRefreshBlocking() {
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeAll((AutoCloseable[])new Closeable[]{this.searcherManager, this.directory});
    }

    @Override
    public ResourceIterator<Path> snapshot() throws IOException {
        return LuceneIndexSnapshots.forIndex(this.partitionFolder, this.directory);
    }
}

