/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;
import org.neo4j.kernel.api.impl.schema.ValueEncoding;
import org.neo4j.util.FeatureToggles;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class LuceneDocumentStructure {
    private static final boolean USE_LUCENE_STANDARD_PREFIX_QUERY = FeatureToggles.flag(LuceneDocumentStructure.class, (String)"lucene.standard.prefix.query", (boolean)false);
    public static final String NODE_ID_KEY = "id";
    private static final ThreadLocal<DocWithId> perThreadDocument = ThreadLocal.withInitial(() -> new DocWithId());
    public static final String DELIMITER = "\u001f";

    private LuceneDocumentStructure() {
    }

    private static DocWithId reuseDocument(long nodeId) {
        DocWithId doc = perThreadDocument.get();
        doc.setId(nodeId);
        return doc;
    }

    public static Document documentRepresentingProperties(long nodeId, Value ... values) {
        DocWithId document = LuceneDocumentStructure.reuseDocument(nodeId);
        document.setValues(values);
        return document.document;
    }

    public static String encodedStringValuesForSampling(Value ... values) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (Value value : values) {
            sb.append(sep);
            sep = DELIMITER;
            ValueEncoding encoding = ValueEncoding.forValue(value);
            sb.append(encoding.encodeField(encoding.key(), value).stringValue());
        }
        return sb.toString();
    }

    public static MatchAllDocsQuery newScanQuery() {
        return new MatchAllDocsQuery();
    }

    public static Query newSeekQuery(Value ... values) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (int i = 0; i < values.length; ++i) {
            builder.add(ValueEncoding.String.encodeQuery(values[i], i), BooleanClause.Occur.MUST);
        }
        return builder.build();
    }

    public static Query newRangeSeekByStringQuery(String lower, boolean includeLower, String upper, boolean includeUpper) {
        boolean includeLowerBoundary = "".equals(lower) || includeLower;
        boolean includeUpperBoundary = "".equals(upper) || includeUpper;
        TermRangeQuery termRangeQuery = TermRangeQuery.newStringRange((String)ValueEncoding.String.key(0), (String)lower, (String)upper, (boolean)includeLowerBoundary, (boolean)includeUpperBoundary);
        if (includeLowerBoundary != includeLower || includeUpperBoundary != includeUpper) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            if (includeLowerBoundary != includeLower) {
                builder.add((Query)new TermQuery(new Term(ValueEncoding.String.key(0), lower)), BooleanClause.Occur.MUST_NOT);
            }
            if (includeUpperBoundary != includeUpper) {
                builder.add((Query)new TermQuery(new Term(ValueEncoding.String.key(0), upper)), BooleanClause.Occur.MUST_NOT);
            }
            builder.add((Query)termRangeQuery, BooleanClause.Occur.FILTER);
            return new ConstantScoreQuery((Query)builder.build());
        }
        return termRangeQuery;
    }

    public static Query newWildCardStringQuery(String searchFor) {
        String searchTerm = QueryParser.escape((String)searchFor);
        Term term = new Term(ValueEncoding.String.key(0), "*" + searchTerm + "*");
        return new WildcardQuery(term);
    }

    public static Query newRangeSeekByPrefixQuery(String prefix) {
        Term term = new Term(ValueEncoding.String.key(0), prefix);
        return USE_LUCENE_STANDARD_PREFIX_QUERY ? new PrefixQuery(term) : new PrefixMultiTermsQuery(term);
    }

    public static Query newSuffixStringQuery(String suffix) {
        String searchTerm = QueryParser.escape((String)suffix);
        Term term = new Term(ValueEncoding.String.key(0), "*" + searchTerm);
        return new WildcardQuery(term);
    }

    public static Term newTermForChangeOrRemove(long nodeId) {
        return new Term(NODE_ID_KEY, "" + nodeId);
    }

    public static long getNodeId(Document from) {
        return Long.parseLong(from.get(NODE_ID_KEY));
    }

    public static boolean useFieldForUniquenessVerification(String fieldName) {
        return !NODE_ID_KEY.equals(fieldName) && ValueEncoding.fieldPropertyNumber(fieldName) == 0;
    }

    private static class DocWithId {
        private final Document document;
        private final Field idField;
        private final Field idValueField;
        private Field[] reusableValueFields = new Field[0];

        private DocWithId() {
            this.idField = new StringField(LuceneDocumentStructure.NODE_ID_KEY, "", Field.Store.YES);
            this.idValueField = new NumericDocValuesField(LuceneDocumentStructure.NODE_ID_KEY, 0L);
            this.document = new Document();
            this.document.add((IndexableField)this.idField);
            this.document.add((IndexableField)this.idValueField);
        }

        private void setId(long id) {
            this.idField.setStringValue(Long.toString(id));
            this.idValueField.setLongValue(id);
        }

        private void setValues(Value ... values) {
            this.removeAllValueFields();
            int neededLength = values.length * ValueEncoding.values().length;
            if (this.reusableValueFields.length < neededLength) {
                this.reusableValueFields = new Field[neededLength];
            }
            for (int i = 0; i < values.length; ++i) {
                if (values[i].valueGroup() != ValueGroup.TEXT) continue;
                Field reusableField = this.getFieldWithValue(i, values[i]);
                this.document.add((IndexableField)reusableField);
            }
        }

        private void removeAllValueFields() {
            this.document.clear();
            this.document.add((IndexableField)this.idField);
            this.document.add((IndexableField)this.idValueField);
        }

        private Field getFieldWithValue(int propertyNumber, Value value) {
            int reuseId = propertyNumber * ValueEncoding.values().length + ValueEncoding.String.ordinal();
            String key = ValueEncoding.String.key(propertyNumber);
            Field reusableField = this.reusableValueFields[reuseId];
            if (reusableField == null) {
                this.reusableValueFields[reuseId] = reusableField = ValueEncoding.String.encodeField(key, value);
            } else {
                ValueEncoding.String.setFieldValue(value, reusableField);
            }
            return reusableField;
        }
    }

    public static class PrefixMultiTermsQuery
    extends MultiTermQuery {
        private Term term;

        public PrefixMultiTermsQuery(Term term) {
            super(term.field());
            this.term = term;
        }

        protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
            return this.term.bytes().length == 0 ? terms.iterator() : new PrefixTermsEnum(terms.iterator(), this.term.bytes());
        }

        public String toString(String field) {
            return ((Object)((Object)this)).getClass().getSimpleName() + ", term:" + String.valueOf(this.term) + ", field:" + field;
        }

        private static class PrefixTermsEnum
        extends FilteredTermsEnum {
            private BytesRef prefix;

            PrefixTermsEnum(TermsEnum termEnum, BytesRef prefix) {
                super(termEnum);
                this.prefix = prefix;
                this.setInitialSeekTerm(this.prefix);
            }

            protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) {
                return StringHelper.startsWith((BytesRef)term, (BytesRef)this.prefix) ? FilteredTermsEnum.AcceptStatus.YES : FilteredTermsEnum.AcceptStatus.END;
            }
        }
    }
}

