/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiBits;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FilteredDocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.Bits;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.api.impl.index.LuceneDocumentRetrievalException;
import org.neo4j.kernel.api.impl.index.SearcherReference;

public class LucenePartitionAllDocumentsReader
implements BoundedIterable<Document> {
    private final SearcherReference searcherReference;
    private final IndexSearcher searcher;
    private final IndexReader reader;

    public LucenePartitionAllDocumentsReader(SearcherReference searcherReference) {
        this.searcherReference = searcherReference;
        this.searcher = searcherReference.getIndexSearcher();
        this.reader = this.searcher.getIndexReader();
    }

    public long maxCount() {
        return this.reader.maxDoc();
    }

    public Iterator<Document> iterator() {
        return this.documentIterator(this.iterateAllDocs());
    }

    public Iterator<Document> iterator(int from, int to) {
        return this.documentIterator(this.iterateDocs(from, to));
    }

    private Iterator<Document> documentIterator(final DocIdSetIterator idIterator) {
        return new PrefetchingIterator<Document>(){

            protected Document fetchNextOrNull() {
                try {
                    int doc = idIterator.nextDoc();
                    if (doc == Integer.MAX_VALUE) {
                        return null;
                    }
                    return LucenePartitionAllDocumentsReader.this.getDocument(doc);
                }
                catch (IOException e) {
                    throw new LuceneDocumentRetrievalException("Can't fetch document id from lucene index.", e);
                }
            }
        };
    }

    public void close() throws IOException {
        this.searcherReference.close();
    }

    private Document getDocument(int docId) {
        try {
            return this.searcher.doc(docId);
        }
        catch (IOException e) {
            throw new LuceneDocumentRetrievalException("Can't retrieve document with id: " + docId + ".", docId, e);
        }
    }

    private DocIdSetIterator iterateAllDocs() {
        return this.filterRemovals(DocIdSetIterator.all((int)this.reader.maxDoc()));
    }

    private DocIdSetIterator iterateDocs(int from, int to) {
        return from == to ? DocIdSetIterator.empty() : this.filterRemovals(DocIdSetIterator.range((int)from, (int)to));
    }

    private DocIdSetIterator filterRemovals(DocIdSetIterator docs) {
        if (!this.reader.hasDeletions()) {
            return docs;
        }
        return new FilteredDocIdSetIterator(docs){
            private final Bits liveDocs;
            {
                this.liveDocs = MultiBits.getLiveDocs((IndexReader)LucenePartitionAllDocumentsReader.this.reader);
            }

            protected boolean match(int doc) {
                return this.liveDocs.get(doc);
            }
        };
    }
}

