/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.reader;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TotalHitCountCollector;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.collector.DocValuesCollector;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.TaskCoordinator;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.kernel.api.impl.schema.sampler.NonUniqueLuceneIndexSampler;
import org.neo4j.kernel.api.impl.schema.sampler.UniqueLuceneIndexSampler;
import org.neo4j.kernel.api.index.AbstractValueIndexReader;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.PartitionedValueSeek;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class SimpleValueIndexReader
extends AbstractValueIndexReader {
    private final SearcherReference searcherReference;
    private final IndexSamplingConfig samplingConfig;
    private final TaskCoordinator taskCoordinator;

    public SimpleValueIndexReader(SearcherReference searcherReference, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TaskCoordinator taskCoordinator) {
        super(descriptor);
        this.searcherReference = searcherReference;
        this.samplingConfig = samplingConfig;
        this.taskCoordinator = taskCoordinator;
    }

    public IndexSampler createSampler() {
        if (this.descriptor.isUnique()) {
            return new UniqueLuceneIndexSampler(this.getIndexSearcher(), this.taskCoordinator);
        }
        return new NonUniqueLuceneIndexSampler(this.getIndexSearcher(), this.taskCoordinator, this.samplingConfig);
    }

    public void query(IndexProgressor.EntityValueClient client, QueryContext context, AccessMode accessMode, IndexQueryConstraints constraints, PropertyIndexQuery ... predicates) throws IndexNotApplicableKernelException {
        SimpleValueIndexReader.validateQuery(this.descriptor, predicates);
        context.monitor().queried(this.descriptor);
        PropertyIndexQuery predicate = predicates[0];
        Query query = SimpleValueIndexReader.toLuceneQuery(this.descriptor, predicate);
        IndexProgressor progressor = this.search(query).getIndexProgressor("id", client);
        client.initialize(this.descriptor, progressor, accessMode, false, constraints, new PropertyIndexQuery[]{predicate});
    }

    public PartitionedValueSeek valueSeek(int desiredNumberOfPartitions, QueryContext context, PropertyIndexQuery ... query) {
        throw new UnsupportedOperationException();
    }

    private DocValuesCollector search(Query query) {
        try {
            DocValuesCollector docValuesCollector = new DocValuesCollector();
            this.getIndexSearcher().search(query, (Collector)docValuesCollector);
            return docValuesCollector;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Query toLuceneQuery(IndexDescriptor index, PropertyIndexQuery predicate) {
        String key = index.getIndexProvider().getKey();
        switch (predicate.type()) {
            case ALL_ENTRIES: 
            case EXISTS: {
                return LuceneDocumentStructure.newScanQuery();
            }
            case EXACT: {
                return LuceneDocumentStructure.newSeekQuery(((PropertyIndexQuery.ExactPredicate)predicate).value());
            }
            case RANGE: {
                PropertyIndexQuery.TextRangePredicate sp = (PropertyIndexQuery.TextRangePredicate)predicate;
                return LuceneDocumentStructure.newRangeSeekByStringQuery(sp.from(), sp.fromInclusive(), sp.to(), sp.toInclusive());
            }
            case STRING_PREFIX: {
                PropertyIndexQuery.StringPrefixPredicate spp = (PropertyIndexQuery.StringPrefixPredicate)predicate;
                return LuceneDocumentStructure.newRangeSeekByPrefixQuery(spp.prefix().stringValue());
            }
            case STRING_CONTAINS: {
                PropertyIndexQuery.StringContainsPredicate scp = (PropertyIndexQuery.StringContainsPredicate)predicate;
                return LuceneDocumentStructure.newWildCardStringQuery(scp.contains().stringValue());
            }
            case STRING_SUFFIX: {
                PropertyIndexQuery.StringSuffixPredicate ssp = (PropertyIndexQuery.StringSuffixPredicate)predicate;
                return LuceneDocumentStructure.newSuffixStringQuery(ssp.suffix().stringValue());
            }
        }
        throw new IllegalArgumentException(String.format("Index query not supported for %s index. Query: %s", key, predicate));
    }

    private static void validateQuery(IndexDescriptor index, PropertyIndexQuery ... predicates) {
        String key = index.getIndexProvider().getKey();
        if (predicates.length > 1) {
            throw new IllegalArgumentException(String.format("Tried to query a %s index with a composite query. Composite queries are not supported by a %s index. Query was: %s ", key, key, Arrays.toString(predicates)));
        }
        PropertyIndexQuery predicate = predicates[0];
        if (predicate.valueGroup() != ValueGroup.TEXT && predicate.type() != IndexQuery.IndexQueryType.ALL_ENTRIES && (index.getIndexType() == IndexType.TEXT || predicate.type() != IndexQuery.IndexQueryType.EXISTS)) {
            throw new IllegalArgumentException(String.format("Index query not supported for %s index. Query: %s", key, predicate));
        }
    }

    public long countIndexedEntities(long entityId, CursorContext cursorContext, int[] propertyKeyIds, Value ... propertyValues) {
        TermQuery entityIdQuery = new TermQuery(LuceneDocumentStructure.newTermForChangeOrRemove(entityId));
        Query valueQuery = LuceneDocumentStructure.newSeekQuery(propertyValues);
        BooleanQuery.Builder entityIdAndValueQuery = new BooleanQuery.Builder();
        entityIdAndValueQuery.add((Query)entityIdQuery, BooleanClause.Occur.MUST);
        entityIdAndValueQuery.add(valueQuery, BooleanClause.Occur.MUST);
        try {
            TotalHitCountCollector collector = new TotalHitCountCollector();
            this.getIndexSearcher().search((Query)entityIdAndValueQuery.build(), (Collector)collector);
            return collector.getTotalHits();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.searcherReference.close();
        }
        catch (IOException e) {
            throw new IndexReaderCloseException(e);
        }
    }

    private IndexSearcher getIndexSearcher() {
        return this.searcherReference.getIndexSearcher();
    }
}

