/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;

public abstract class LuceneIndexPopulatingUpdater
implements IndexUpdater {
    private final LuceneIndexWriter writer;

    public LuceneIndexPopulatingUpdater(LuceneIndexWriter writer) {
        this.writer = writer;
    }

    public void process(IndexEntryUpdate<?> update) {
        ValueIndexEntryUpdate valueUpdate = this.asValueUpdate(update);
        long nodeId = valueUpdate.getEntityId();
        try {
            switch (valueUpdate.updateMode()) {
                case ADDED: {
                    this.added(valueUpdate);
                    this.writer.updateDocument(LuceneDocumentStructure.newTermForChangeOrRemove(nodeId), LuceneDocumentStructure.documentRepresentingProperties(nodeId, valueUpdate.values()));
                    break;
                }
                case CHANGED: {
                    this.changed(valueUpdate);
                    this.writer.updateDocument(LuceneDocumentStructure.newTermForChangeOrRemove(nodeId), LuceneDocumentStructure.documentRepresentingProperties(nodeId, valueUpdate.values()));
                    break;
                }
                case REMOVED: {
                    this.removed(valueUpdate);
                    this.writer.deleteDocuments(LuceneDocumentStructure.newTermForChangeOrRemove(nodeId));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown update mode " + valueUpdate.updateMode() + " for values " + Arrays.toString(valueUpdate.values()));
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected abstract void added(ValueIndexEntryUpdate<?> var1);

    protected abstract void changed(ValueIndexEntryUpdate<?> var1);

    protected abstract void removed(ValueIndexEntryUpdate<?> var1);
}

