/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.index.LuceneAllDocumentsReader;
import org.neo4j.kernel.api.impl.index.LuceneIndexConsistencyCheckVisitor;
import org.neo4j.kernel.api.impl.schema.LuceneIndexReaderAcquisitionException;
import org.neo4j.kernel.api.impl.schema.reader.LuceneAllEntriesIndexAccessorReader;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntriesReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;

public abstract class AbstractLuceneIndexAccessor<READER extends ValueIndexReader, INDEX extends DatabaseIndex<READER>>
implements IndexAccessor {
    protected final LuceneIndexWriter writer;
    protected final INDEX luceneIndex;
    protected final IndexDescriptor descriptor;

    protected AbstractLuceneIndexAccessor(INDEX luceneIndex, IndexDescriptor descriptor) {
        this.writer = luceneIndex.isReadOnly() ? null : luceneIndex.getIndexWriter();
        this.luceneIndex = luceneIndex;
        this.descriptor = descriptor;
    }

    public IndexUpdater newUpdater(IndexUpdateMode mode, CursorContext cursorContext) {
        if (this.luceneIndex.isReadOnly()) {
            throw new UnsupportedOperationException("Can't create index updater while database is in read only mode.");
        }
        return this.getIndexUpdater(mode);
    }

    protected abstract IndexUpdater getIndexUpdater(IndexUpdateMode var1);

    public void drop() {
        if (this.luceneIndex.isReadOnly()) {
            throw new UnsupportedOperationException("Can't drop index while database is in read only mode.");
        }
        this.luceneIndex.drop();
    }

    public void force(CursorContext cursorContext) {
        try {
            if (!this.luceneIndex.isReadOnly()) {
                this.luceneIndex.markAsOnline();
            }
            this.luceneIndex.maybeRefreshBlocking();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void refresh() {
        try {
            this.luceneIndex.maybeRefreshBlocking();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void close() {
        try {
            this.luceneIndex.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public READER newValueReader() {
        try {
            return this.luceneIndex.getIndexReader();
        }
        catch (IOException e) {
            throw new LuceneIndexReaderAcquisitionException("Can't acquire index reader", e);
        }
    }

    public BoundedIterable<Long> newAllEntriesReader(ToLongFunction<Document> entityIdReader, long fromIdInclusive, long toIdExclusive) {
        return new LuceneAllEntriesIndexAccessorReader(this.luceneIndex.allDocumentsReader(), entityIdReader, fromIdInclusive, toIdExclusive);
    }

    public IndexEntriesReader[] newAllEntriesValueReader(ToLongFunction<Document> entityIdReader, int numPartitions) {
        LuceneAllDocumentsReader allDocumentsReader = this.luceneIndex.allDocumentsReader();
        List<Iterator<Document>> partitions = allDocumentsReader.partition(numPartitions);
        AtomicInteger closeCount = new AtomicInteger(partitions.size());
        List readers = partitions.stream().map(partitionDocuments -> new PartitionIndexEntriesReader(closeCount, allDocumentsReader, entityIdReader, (Iterator<Document>)partitionDocuments)).collect(Collectors.toList());
        return (IndexEntriesReader[])readers.toArray(IndexEntriesReader[]::new);
    }

    public ResourceIterator<Path> snapshotFiles() {
        try {
            return this.luceneIndex.snapshot();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public abstract void verifyDeferredConstraints(NodePropertyAccessor var1) throws IndexEntryConflictException;

    public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContext cursorContext) {
        LuceneIndexConsistencyCheckVisitor visitor = (LuceneIndexConsistencyCheckVisitor)reporterFactory.getClass(LuceneIndexConsistencyCheckVisitor.class);
        boolean isConsistent = this.luceneIndex.isValid();
        if (!isConsistent) {
            visitor.isInconsistent(this.descriptor);
        }
        return isConsistent;
    }

    public long estimateNumberOfEntries(CursorContext ignored) {
        return this.luceneIndex.allDocumentsReader().maxCount();
    }

    protected abstract class AbstractLuceneIndexUpdater
    implements IndexUpdater {
        private final boolean idempotent;
        private final boolean refresh;
        private boolean hasChanges;

        protected AbstractLuceneIndexUpdater(boolean idempotent, boolean refresh) {
            this.idempotent = idempotent;
            this.refresh = refresh;
        }

        public void process(IndexEntryUpdate<?> update) {
            assert (update.indexKey().schema().equals(AbstractLuceneIndexAccessor.this.descriptor.schema()));
            ValueIndexEntryUpdate valueUpdate = this.asValueUpdate(update);
            switch (valueUpdate.updateMode()) {
                case ADDED: {
                    if (this.idempotent) {
                        this.addIdempotent(valueUpdate.getEntityId(), valueUpdate.values());
                        break;
                    }
                    this.add(valueUpdate.getEntityId(), valueUpdate.values());
                    break;
                }
                case CHANGED: {
                    this.change(valueUpdate.getEntityId(), valueUpdate.values());
                    break;
                }
                case REMOVED: {
                    this.remove(valueUpdate.getEntityId());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            this.hasChanges = true;
        }

        public void close() {
            if (this.hasChanges && this.refresh) {
                try {
                    AbstractLuceneIndexAccessor.this.luceneIndex.maybeRefreshBlocking();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }

        protected abstract void addIdempotent(long var1, Value[] var3);

        protected abstract void add(long var1, Value[] var3);

        protected abstract void change(long var1, Value[] var3);

        protected abstract void remove(long var1);
    }

    private static class PartitionIndexEntriesReader
    implements IndexEntriesReader {
        private final AtomicInteger closeCount;
        private final LuceneAllDocumentsReader allDocumentsReader;
        private final ToLongFunction<Document> entityIdReader;
        private final Iterator<Document> partitionDocuments;

        PartitionIndexEntriesReader(AtomicInteger closeCount, LuceneAllDocumentsReader allDocumentsReader, ToLongFunction<Document> entityIdReader, Iterator<Document> partitionDocuments) {
            this.closeCount = closeCount;
            this.allDocumentsReader = allDocumentsReader;
            this.entityIdReader = entityIdReader;
            this.partitionDocuments = partitionDocuments;
        }

        public Value[] values() {
            return null;
        }

        public void close() {
            if (this.closeCount.decrementAndGet() == 0) {
                try {
                    this.allDocumentsReader.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }

        public long next() {
            return this.entityIdReader.applyAsLong(this.partitionDocuments.next());
        }

        public boolean hasNext() {
            return this.partitionDocuments.hasNext();
        }
    }
}

