/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.reader;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.sampler.AggregatingIndexSampler;
import org.neo4j.kernel.api.impl.schema.TaskCoordinator;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.kernel.api.impl.schema.reader.SimpleValueIndexReader;
import org.neo4j.kernel.api.index.AbstractValueIndexReader;
import org.neo4j.kernel.api.index.BridgingIndexProgressor;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.values.storable.Value;

public class PartitionedValueIndexReader
extends AbstractValueIndexReader {
    private final List<SimpleValueIndexReader> indexReaders;

    public PartitionedValueIndexReader(List<SearcherReference> partitionSearchers, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TaskCoordinator taskCoordinator) {
        this(descriptor, partitionSearchers.stream().map(partitionSearcher -> new SimpleValueIndexReader((SearcherReference)partitionSearcher, descriptor, samplingConfig, taskCoordinator)).collect(Collectors.toList()));
    }

    PartitionedValueIndexReader(IndexDescriptor descriptor, List<SimpleValueIndexReader> readers) {
        super(descriptor);
        this.indexReaders = readers;
    }

    public void query(QueryContext context, IndexProgressor.EntityValueClient client, IndexQueryConstraints constraints, PropertyIndexQuery ... query) throws IndexNotApplicableKernelException {
        try {
            BridgingIndexProgressor bridgingIndexProgressor = new BridgingIndexProgressor(client, this.descriptor.schema().getPropertyIds());
            this.indexReaders.parallelStream().forEach(reader -> {
                try {
                    reader.query(context, (IndexProgressor.EntityValueClient)bridgingIndexProgressor, constraints, query);
                }
                catch (IndexNotApplicableKernelException e) {
                    throw new InnerException(e);
                }
            });
            client.initialize(this.descriptor, (IndexProgressor)bridgingIndexProgressor, query, constraints, false);
        }
        catch (InnerException e) {
            throw e.getCause();
        }
    }

    public long countIndexedEntities(long entityId, CursorContext cursorContext, int[] propertyKeyIds, Value ... propertyValues) {
        return this.indexReaders.parallelStream().mapToLong(reader -> reader.countIndexedEntities(entityId, cursorContext, propertyKeyIds, propertyValues)).sum();
    }

    public IndexSampler createSampler() {
        List<IndexSampler> indexSamplers = this.indexReaders.parallelStream().map(SimpleValueIndexReader::createSampler).collect(Collectors.toList());
        return new AggregatingIndexSampler(indexSamplers);
    }

    public void close() {
        try {
            IOUtils.closeAll(this.indexReaders);
        }
        catch (IOException e) {
            throw new IndexReaderCloseException(e);
        }
    }

    private static final class InnerException
    extends RuntimeException {
        private InnerException(IndexNotApplicableKernelException e) {
            super((Throwable)e);
        }

        public synchronized IndexNotApplicableKernelException getCause() {
            return (IndexNotApplicableKernelException)super.getCause();
        }
    }
}

