/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.populator.LuceneIndexPopulatingUpdater;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.NonUniqueIndexSampler;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;

public class NonUniqueLuceneIndexPopulatingUpdater
extends LuceneIndexPopulatingUpdater {
    private final NonUniqueIndexSampler sampler;

    public NonUniqueLuceneIndexPopulatingUpdater(LuceneIndexWriter writer, NonUniqueIndexSampler sampler) {
        super(writer);
        this.sampler = sampler;
    }

    @Override
    protected void added(ValueIndexEntryUpdate<?> update) {
        String encodedValue = LuceneDocumentStructure.encodedStringValuesForSampling(update.values());
        this.sampler.include(encodedValue);
    }

    @Override
    protected void changed(ValueIndexEntryUpdate<?> update) {
        String encodedValueBefore = LuceneDocumentStructure.encodedStringValuesForSampling(update.beforeValues());
        this.sampler.exclude(encodedValueBefore);
        String encodedValueAfter = LuceneDocumentStructure.encodedStringValuesForSampling(update.values());
        this.sampler.include(encodedValueAfter);
    }

    @Override
    protected void removed(ValueIndexEntryUpdate<?> update) {
        String removedValue = LuceneDocumentStructure.encodedStringValuesForSampling(update.values());
        this.sampler.exclude(removedValue);
    }

    public void close() {
    }
}

