/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.internal.helpers.Cancelable;
import org.neo4j.internal.helpers.CancellationRequest;

public class TaskCoordinator
implements Cancelable,
CancellationRequest {
    private static final AtomicInteger tasks = new AtomicInteger();
    private volatile boolean cancelled;

    public void cancel() {
        this.cancelled = true;
    }

    public void awaitCompletion() throws InterruptedException {
        while (tasks.get() > 0) {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
    }

    public boolean cancellationRequested() {
        return this.cancelled;
    }

    public Task newTask() {
        Task task = new Task();
        if (this.cancelled) {
            task.close();
            throw new IllegalStateException("This manager has already been cancelled.");
        }
        return task;
    }

    public class Task
    implements AutoCloseable,
    CancellationRequest {
        Task() {
            tasks.incrementAndGet();
        }

        @Override
        public void close() {
            tasks.decrementAndGet();
        }

        public boolean cancellationRequested() {
            return TaskCoordinator.this.cancellationRequested();
        }
    }
}

