/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.sampler;

import java.util.List;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexSampler;

public class AggregatingIndexSampler
implements IndexSampler {
    private final List<IndexSampler> indexSamplers;

    public AggregatingIndexSampler(List<IndexSampler> indexSamplers) {
        this.indexSamplers = indexSamplers;
    }

    public IndexSample sampleIndex(PageCursorTracer cursorTracer) {
        return this.indexSamplers.parallelStream().map(sampler -> this.sampleIndex((IndexSampler)sampler, cursorTracer)).reduce(this::combine).get();
    }

    private IndexSample sampleIndex(IndexSampler sampler, PageCursorTracer cursorTracer) {
        try {
            return sampler.sampleIndex(cursorTracer);
        }
        catch (IndexNotFoundKernelException e) {
            throw new RuntimeException(e);
        }
    }

    public IndexSample combine(IndexSample sample1, IndexSample sample2) {
        long indexSize = Math.addExact(sample1.indexSize(), sample2.indexSize());
        long uniqueValues = Math.addExact(sample1.uniqueValues(), sample2.uniqueValues());
        long sampleSize = Math.addExact(sample1.sampleSize(), sample2.sampleSize());
        return new IndexSample(indexSize, uniqueValues, sampleSize);
    }

    public void close() {
        IOUtils.closeAllSilently(this.indexSamplers);
    }
}

