/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.common.Validator;
import org.neo4j.kernel.impl.api.ArrayEncoder;
import org.neo4j.kernel.impl.api.IndexTextValueLengthValidator;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class LuceneIndexValueValidator
implements Validator<Value> {
    public static final LuceneIndexValueValidator INSTANCE = new LuceneIndexValueValidator();
    public static final int MAX_TERM_LENGTH = 32766;
    private final IndexTextValueLengthValidator textValueValidator = new IndexTextValueLengthValidator(32766);

    private LuceneIndexValueValidator() {
    }

    public void validate(Value value) {
        this.textValueValidator.validate(value);
        if (Values.isArrayValue((Value)value)) {
            this.textValueValidator.validate(ArrayEncoder.encode(value).getBytes());
        }
    }

    public void validate(byte[] encodedValue) {
        this.textValueValidator.validate(encodedValue);
    }
}

