/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.neo4j.kernel.api.index.ArrayEncoder;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public enum ValueEncoding {
    Number{

        @Override
        public String key() {
            return "number";
        }

        @Override
        boolean canEncode(Value value) {
            return Values.isNumberValue((Object)value);
        }

        @Override
        Field encodeField(String name, Value value) {
            return new DoubleField(name, Values.coerceToDouble((Value)value), Field.Store.NO);
        }

        @Override
        void setFieldValue(Value value, Field field) {
            field.setDoubleValue(Values.coerceToDouble((Value)value));
        }

        @Override
        Query encodeQuery(Value value, int propertyNumber) {
            Double doubleValue = Values.coerceToDouble((Value)value);
            return new ConstantScoreQuery((Query)NumericRangeQuery.newDoubleRange((String)this.key(propertyNumber), (Double)doubleValue, (Double)doubleValue, (boolean)true, (boolean)true));
        }
    }
    ,
    Array{

        @Override
        public String key() {
            return "array";
        }

        @Override
        boolean canEncode(Value value) {
            return Values.isArrayValue((Value)value);
        }

        @Override
        Field encodeField(String name, Value value) {
            return ValueEncoding.stringField(name, ArrayEncoder.encode((Value)value));
        }

        @Override
        void setFieldValue(Value value, Field field) {
            field.setStringValue(ArrayEncoder.encode((Value)value));
        }

        @Override
        Query encodeQuery(Value value, int propertyNumber) {
            return new ConstantScoreQuery((Query)new TermQuery(new Term(this.key(propertyNumber), ArrayEncoder.encode((Value)value))));
        }
    }
    ,
    Bool{

        @Override
        public String key() {
            return "bool";
        }

        @Override
        boolean canEncode(Value value) {
            return Values.isBooleanValue((Object)value);
        }

        @Override
        Field encodeField(String name, Value value) {
            return ValueEncoding.stringField(name, value.prettyPrint());
        }

        @Override
        void setFieldValue(Value value, Field field) {
            field.setStringValue(value.prettyPrint());
        }

        @Override
        Query encodeQuery(Value value, int propertyNumber) {
            return new ConstantScoreQuery((Query)new TermQuery(new Term(this.key(propertyNumber), value.prettyPrint())));
        }
    }
    ,
    Spatial{

        @Override
        public String key() {
            return "spatial";
        }

        @Override
        boolean canEncode(Value value) {
            return Values.isGeometryValue((Value)value);
        }

        @Override
        Field encodeField(String name, Value value) {
            PointValue pointVal = (PointValue)value;
            return ValueEncoding.stringField(name, pointVal.toIndexableString());
        }

        @Override
        void setFieldValue(Value value, Field field) {
            PointValue pointVal = (PointValue)value;
            field.setStringValue(pointVal.toIndexableString());
        }

        @Override
        Query encodeQuery(Value value, int propertyNumber) {
            PointValue pointVal = (PointValue)value;
            return new ConstantScoreQuery((Query)new TermQuery(new Term(this.key(propertyNumber), pointVal.toIndexableString())));
        }
    }
    ,
    Temporal{

        @Override
        public String key() {
            return "temporal";
        }

        @Override
        boolean canEncode(Value value) {
            return Values.isTemporalValue((Value)value);
        }

        @Override
        Field encodeField(String name, Value value) {
            return ValueEncoding.stringField(name, value.prettyPrint());
        }

        @Override
        void setFieldValue(Value value, Field field) {
            field.setStringValue(value.prettyPrint());
        }

        @Override
        Query encodeQuery(Value value, int propertyNumber) {
            return new ConstantScoreQuery((Query)new TermQuery(new Term(this.key(propertyNumber), value.prettyPrint())));
        }
    }
    ,
    String{

        @Override
        public String key() {
            return "string";
        }

        @Override
        boolean canEncode(Value value) {
            return true;
        }

        @Override
        Field encodeField(String name, Value value) {
            return ValueEncoding.stringField(name, value.asObject().toString());
        }

        @Override
        void setFieldValue(Value value, Field field) {
            field.setStringValue(value.asObject().toString());
        }

        @Override
        Query encodeQuery(Value value, int propertyNumber) {
            return new ConstantScoreQuery((Query)new TermQuery(new Term(this.key(propertyNumber), value.asObject().toString())));
        }
    };

    private static final ValueEncoding[] AllEncodings;

    public abstract String key();

    String key(int propertyNumber) {
        if (propertyNumber == 0) {
            return this.key();
        }
        return propertyNumber + this.key();
    }

    static int fieldPropertyNumber(String fieldName) {
        int index = 0;
        for (int i = 0; i < fieldName.length() && Character.isDigit(fieldName.charAt(i)); ++i) {
            ++index;
        }
        return index == 0 ? 0 : Integer.parseInt(fieldName.substring(0, index));
    }

    abstract boolean canEncode(Value var1);

    abstract Field encodeField(String var1, Value var2);

    abstract void setFieldValue(Value var1, Field var2);

    abstract Query encodeQuery(Value var1, int var2);

    public static ValueEncoding forKey(String key) {
        for (ValueEncoding encoding : AllEncodings) {
            if (!key.endsWith(encoding.key())) continue;
            return encoding;
        }
        throw new IllegalArgumentException("Unknown key: " + key);
    }

    public static ValueEncoding forValue(Value value) {
        for (ValueEncoding encoding : AllEncodings) {
            if (!encoding.canEncode(value)) continue;
            return encoding;
        }
        throw new IllegalStateException("Unable to encode the value " + value);
    }

    private static Field stringField(String identifier, String value) {
        return new StringField(identifier, value, Field.Store.NO);
    }

    static {
        AllEncodings = ValueEncoding.values();
    }
}

