/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.writer;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.neo4j.kernel.api.impl.index.WritableAbstractDatabaseIndex;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;

public class PartitionedIndexWriter
implements LuceneIndexWriter {
    private final WritableAbstractDatabaseIndex index;
    private final Integer MAXIMUM_PARTITION_SIZE = Integer.getInteger("luceneSchemaIndex.maxPartitionSize", 1932735168);

    public PartitionedIndexWriter(WritableAbstractDatabaseIndex index) {
        this.index = index;
    }

    @Override
    public void addDocument(Document doc) throws IOException {
        this.getIndexWriter(1).addDocument((Iterable)doc);
    }

    @Override
    public void addDocuments(int numDocs, Iterable<Document> documents) throws IOException {
        this.getIndexWriter(numDocs).addDocuments(documents);
    }

    @Override
    public void updateDocument(Term term, Document doc) throws IOException {
        List partitions = this.index.getPartitions();
        if (this.index.hasSinglePartition(partitions) && this.writablePartition(this.index.getFirstPartition(partitions), 1)) {
            this.index.getFirstPartition(partitions).getIndexWriter().updateDocument(term, (Iterable)doc);
        } else {
            this.deleteDocuments(term);
            this.addDocument(doc);
        }
    }

    @Override
    public void deleteDocuments(Query query) throws IOException {
        List partitions = this.index.getPartitions();
        for (AbstractIndexPartition partition : partitions) {
            partition.getIndexWriter().deleteDocuments(new Query[]{query});
        }
    }

    @Override
    public void deleteDocuments(Term term) throws IOException {
        List partitions = this.index.getPartitions();
        for (AbstractIndexPartition partition : partitions) {
            partition.getIndexWriter().deleteDocuments(new Term[]{term});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexWriter getIndexWriter(int numDocs) throws IOException {
        WritableAbstractDatabaseIndex writableAbstractDatabaseIndex = this.index;
        synchronized (writableAbstractDatabaseIndex) {
            return this.unsafeGetIndexWriter(numDocs);
        }
    }

    private IndexWriter unsafeGetIndexWriter(int numDocs) throws IOException {
        List indexPartitions = this.index.getPartitions();
        int size = indexPartitions.size();
        for (int i = 0; i < size; ++i) {
            AbstractIndexPartition partition = (AbstractIndexPartition)indexPartitions.get(i);
            if (!this.writablePartition(partition, numDocs)) continue;
            return partition.getIndexWriter();
        }
        AbstractIndexPartition indexPartition = this.index.addNewPartition();
        return indexPartition.getIndexWriter();
    }

    private boolean writablePartition(AbstractIndexPartition partition, int numDocs) {
        return this.MAXIMUM_PARTITION_SIZE - partition.getIndexWriter().maxDoc() >= numDocs;
    }
}

