/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.storage;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.NRTCachingDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.neo4j.util.FeatureToggles;

public interface DirectoryFactory
extends AutoCloseable {
    public static final DirectoryFactory PERSISTENT = new DirectoryFactory(){
        private final int MAX_MERGE_SIZE_MB = FeatureToggles.getInteger(DirectoryFactory.class, (String)"max_merge_size_mb", (int)5);
        private final int MAX_CACHED_MB = FeatureToggles.getInteger(DirectoryFactory.class, (String)"max_cached_mb", (int)50);
        private final boolean USE_DEFAULT_DIRECTORY_FACTORY = FeatureToggles.flag(DirectoryFactory.class, (String)"default_directory_factory", (boolean)true);

        @Override
        public Directory open(File dir) throws IOException {
            dir.mkdirs();
            NIOFSDirectory directory = this.USE_DEFAULT_DIRECTORY_FACTORY ? FSDirectory.open((Path)dir.toPath()) : new NIOFSDirectory(dir.toPath());
            return new NRTCachingDirectory((Directory)directory, (double)this.MAX_MERGE_SIZE_MB, (double)this.MAX_CACHED_MB);
        }

        @Override
        public void close() {
        }
    };

    public static DirectoryFactory directoryFactory(boolean ephemeral) {
        return ephemeral ? new InMemoryDirectoryFactory() : PERSISTENT;
    }

    public Directory open(File var1) throws IOException;

    public static final class UncloseableDirectory
    extends FilterDirectory {
        public UncloseableDirectory(Directory delegate) {
            super(delegate);
        }

        public void close() {
        }
    }

    public static final class Single
    implements DirectoryFactory {
        private final Directory directory;

        public Single(Directory directory) {
            this.directory = directory;
        }

        @Override
        public Directory open(File dir) {
            return this.directory;
        }

        @Override
        public void close() {
        }
    }

    public static final class InMemoryDirectoryFactory
    implements DirectoryFactory {
        private final Map<File, RAMDirectory> directories = new HashMap<File, RAMDirectory>();

        @Override
        public synchronized Directory open(File dir) {
            if (!this.directories.containsKey(dir)) {
                this.directories.put(dir, new RAMDirectory());
            }
            return new UncloseableDirectory((Directory)this.directories.get(dir));
        }

        @Override
        public synchronized void close() {
            for (RAMDirectory ramDirectory : this.directories.values()) {
                ramDirectory.close();
            }
            this.directories.clear();
        }
    }
}

