/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;

public abstract class LuceneUtil {
    static void close(IndexWriter writer) {
        LuceneUtil.close((Object)writer);
    }

    static void close(IndexSearcher searcher) {
        LuceneUtil.close((Object)searcher);
    }

    static void close(IndexReader reader) {
        LuceneUtil.close((Object)reader);
    }

    private static void close(Object object) {
        if (object == null) {
            return;
        }
        try {
            if (object instanceof IndexWriter) {
                ((IndexWriter)object).close();
            } else if (object instanceof IndexReader) {
                ((IndexReader)object).close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Query rangeQuery(String key, Number from, Number to, boolean includeFrom, boolean includeTo) {
        if (from instanceof Long || to instanceof Long) {
            return NumericRangeQuery.newLongRange((String)key, (Long)(from != null ? from.longValue() : 0L), (Long)(to != null ? to.longValue() : Long.MAX_VALUE), (boolean)includeFrom, (boolean)includeTo);
        }
        if (from instanceof Double || to instanceof Double) {
            return NumericRangeQuery.newDoubleRange((String)key, (Double)(from != null ? from.doubleValue() : 0.0), (Double)(to != null ? to.doubleValue() : Double.MAX_VALUE), (boolean)includeFrom, (boolean)includeTo);
        }
        if (from instanceof Float || to instanceof Float) {
            return NumericRangeQuery.newFloatRange((String)key, (Float)Float.valueOf(from != null ? from.floatValue() : 0.0f), (Float)Float.valueOf(to != null ? to.floatValue() : Float.MAX_VALUE), (boolean)includeFrom, (boolean)includeTo);
        }
        return NumericRangeQuery.newIntRange((String)key, (Integer)(from != null ? from.intValue() : 0), (Integer)(to != null ? to.intValue() : Integer.MAX_VALUE), (boolean)includeFrom, (boolean)includeTo);
    }
}

