/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.verification;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.verification.DuplicateCheckingCollector;
import org.neo4j.kernel.api.impl.schema.verification.UniquenessVerifier;
import org.neo4j.kernel.api.index.PropertyAccessor;

public class SimpleUniquenessVerifier
implements UniquenessVerifier {
    private final PartitionSearcher partitionSearcher;

    public SimpleUniquenessVerifier(PartitionSearcher partitionSearcher) {
        this.partitionSearcher = partitionSearcher;
    }

    @Override
    public void verify(PropertyAccessor accessor, int[] propKeyIds) throws IndexEntryConflictException, IOException {
        try {
            DuplicateCheckingCollector collector = DuplicateCheckingCollector.forProperties(accessor, propKeyIds);
            IndexSearcher searcher = this.indexSearcher();
            for (LeafReaderContext leafReaderContext : searcher.getIndexReader().leaves()) {
                Fields fields = leafReaderContext.reader().fields();
                for (String field : fields) {
                    BytesRef termsRef;
                    if ("id".equals(field)) continue;
                    TermsEnum terms = LuceneDocumentStructure.originalTerms(fields.terms(field), field);
                    while ((termsRef = terms.next()) != null) {
                        if (terms.docFreq() <= 1) continue;
                        collector.reset();
                        searcher.search((Query)new TermQuery(new Term(field, termsRef)), (Collector)collector);
                    }
                }
            }
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IndexEntryConflictException) {
                throw (IndexEntryConflictException)cause;
            }
            throw e;
        }
    }

    @Override
    public void verify(PropertyAccessor accessor, int[] propKeyIds, List<Object> updatedPropertyValues) throws IndexEntryConflictException, IOException {
        try {
            DuplicateCheckingCollector collector = DuplicateCheckingCollector.forProperties(accessor, propKeyIds);
            for (Object propertyValue : updatedPropertyValues) {
                collector.reset();
                Query query = LuceneDocumentStructure.newSeekQuery(propertyValue);
                this.indexSearcher().search(query, (Collector)collector);
            }
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IndexEntryConflictException) {
                throw (IndexEntryConflictException)cause;
            }
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        this.partitionSearcher.close();
    }

    private IndexSearcher indexSearcher() {
        return this.partitionSearcher.getIndexSearcher();
    }
}

