/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.verification;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.SimpleCollector;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.index.PreexistingIndexEntryConflictException;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.properties.Property;

public class DuplicateCheckingCollector
extends SimpleCollector {
    private final PropertyAccessor accessor;
    private final int propertyKeyId;
    private EntrySet actualValues;
    private LeafReader reader;

    public DuplicateCheckingCollector(PropertyAccessor accessor, int propertyKeyId) {
        this.accessor = accessor;
        this.propertyKeyId = propertyKeyId;
        this.actualValues = new EntrySet();
    }

    public void collect(int doc) throws IOException {
        try {
            this.doCollect(doc);
        }
        catch (KernelException e) {
            throw new IllegalStateException("Indexed node should exist and have the indexed property.", e);
        }
        catch (PreexistingIndexEntryConflictException e) {
            throw new IOException(e);
        }
    }

    private void doCollect(int doc) throws IOException, KernelException, PreexistingIndexEntryConflictException {
        Document document = this.reader.document(doc);
        long nodeId = LuceneDocumentStructure.getNodeId(document);
        Property property = this.accessor.getProperty(nodeId, this.propertyKeyId);
        EntrySet current = this.actualValues;
        block0: do {
            for (int i = 0; i < 10000; ++i) {
                Object value = current.value[i];
                if (current.nodeId[i] == -1L) {
                    current.value[i] = property.value();
                    current.nodeId[i] = nodeId;
                    if (i != 9999) break block0;
                    current.next = new EntrySet();
                    break block0;
                }
                if (!property.valueEquals(value)) continue;
                throw new PreexistingIndexEntryConflictException(value, current.nodeId[i], nodeId);
            }
        } while ((current = current.next) != null);
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.reader = context.reader();
    }

    public boolean needsScores() {
        return false;
    }

    public void reset() {
        this.actualValues = new EntrySet();
    }

    private static class EntrySet {
        static final int INCREMENT = 10000;
        Object[] value = new Object[10000];
        long[] nodeId = new long[10000];
        EntrySet next;

        EntrySet() {
            Arrays.fill(this.nodeId, -1L);
        }
    }
}

