/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.storage;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.NRTCachingDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;

public interface DirectoryFactory
extends FileSystemAbstraction.ThirdPartyFileSystem {
    public static final DirectoryFactory PERSISTENT = new DirectoryFactory(){
        private final int MAX_MERGE_SIZE_MB = FeatureToggles.getInteger(DirectoryFactory.class, (String)"max_merge_size_mb", (int)5);
        private final int MAX_CACHED_MB = FeatureToggles.getInteger(DirectoryFactory.class, (String)"max_cached_mb", (int)50);

        @Override
        public Directory open(File dir) throws IOException {
            dir.mkdirs();
            return new NRTCachingDirectory((Directory)FSDirectory.open((Path)dir.toPath()), (double)this.MAX_MERGE_SIZE_MB, (double)this.MAX_CACHED_MB);
        }

        @Override
        public void close() {
        }

        public void dumpToZip(ZipOutputStream zip, byte[] scratchPad) {
        }
    };

    public Directory open(File var1) throws IOException;

    public void close();

    public static final class UncloseableDirectory
    extends Directory {
        private final Directory delegate;

        public UncloseableDirectory(Directory delegate) {
            this.delegate = delegate;
        }

        public void close() throws IOException {
        }

        public String[] listAll() throws IOException {
            return this.delegate.listAll();
        }

        public void renameFile(String source, String dest) throws IOException {
            this.delegate.renameFile(source, dest);
        }

        public void deleteFile(String s) throws IOException {
            this.delegate.deleteFile(s);
        }

        public long fileLength(String s) throws IOException {
            return this.delegate.fileLength(s);
        }

        public IndexOutput createOutput(String name, IOContext context) throws IOException {
            return this.delegate.createOutput(name, context);
        }

        public void sync(Collection<String> names) throws IOException {
            this.delegate.sync(names);
        }

        public IndexInput openInput(String name, IOContext context) throws IOException {
            return this.delegate.openInput(name, context);
        }

        public Lock obtainLock(String name) throws IOException {
            return this.delegate.obtainLock(name);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    public static final class Single
    implements DirectoryFactory {
        private final Directory directory;

        public Single(Directory directory) {
            this.directory = directory;
        }

        @Override
        public Directory open(File dir) throws IOException {
            return this.directory;
        }

        @Override
        public void close() {
        }

        public void dumpToZip(ZipOutputStream zip, byte[] scratchPad) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class InMemoryDirectoryFactory
    implements DirectoryFactory {
        private final Map<File, RAMDirectory> directories = new HashMap<File, RAMDirectory>();

        @Override
        public synchronized Directory open(File dir) throws IOException {
            if (!this.directories.containsKey(dir)) {
                this.directories.put(dir, new RAMDirectory());
            }
            return new UncloseableDirectory((Directory)this.directories.get(dir));
        }

        @Override
        public synchronized void close() {
            for (RAMDirectory ramDirectory : this.directories.values()) {
                ramDirectory.close();
            }
            this.directories.clear();
        }

        public void dumpToZip(ZipOutputStream zip, byte[] scratchPad) throws IOException {
            for (Map.Entry<File, RAMDirectory> entry : this.directories.entrySet()) {
                RAMDirectory ramDir = entry.getValue();
                for (String fileName : ramDir.listAll()) {
                    zip.putNextEntry(new ZipEntry(new File(entry.getKey(), fileName).getAbsolutePath()));
                    InMemoryDirectoryFactory.copy(ramDir.openInput(fileName, IOContext.DEFAULT), zip, scratchPad);
                    zip.closeEntry();
                }
            }
        }

        private static void copy(IndexInput source, OutputStream target, byte[] buffer) throws IOException {
            long read;
            for (long remaining = source.length(); remaining > 0L; remaining -= read) {
                read = Math.min(remaining, (long)buffer.length);
                source.readBytes(buffer, 0, (int)read);
                target.write(buffer, 0, (int)read);
            }
        }
    }
}

