/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.neo4j.kernel.api.impl.index.collector.FirstHitCollector;
import org.neo4j.kernel.api.impl.index.partition.IndexPartition;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.labelscan.LuceneLabelScanIndex;
import org.neo4j.kernel.api.impl.labelscan.bitmaps.Bitmap;
import org.neo4j.kernel.api.impl.labelscan.storestrategy.BitmapDocumentFormat;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;

public class PartitionedLuceneLabelScanWriter
implements LabelScanWriter {
    private final Integer MAXIMUM_PARTITION_SIZE = Integer.getInteger("labelScanStore.maxPartitionSize", 0x7FFFFF7F);
    private final BitmapDocumentFormat format;
    private final List<NodeLabelUpdate> updates;
    private long currentRange;
    private LuceneLabelScanIndex index;

    public PartitionedLuceneLabelScanWriter(LuceneLabelScanIndex index, BitmapDocumentFormat format) {
        this.index = index;
        this.format = format;
        this.currentRange = -1L;
        this.updates = new ArrayList<NodeLabelUpdate>(format.bitmapFormat().rangeSize());
    }

    public void write(NodeLabelUpdate update) throws IOException {
        long range = this.format.bitmapFormat().rangeOf(update.getNodeId());
        if (range != this.currentRange) {
            if (range < this.currentRange) {
                throw new IllegalArgumentException(String.format("NodeLabelUpdates must be supplied in order of ascending node id. Current range:%d, node id of this update:%d", this.currentRange, update.getNodeId()));
            }
            this.flush();
            this.currentRange = range;
        }
        this.updates.add(update);
    }

    public void close() throws IOException {
        this.flush();
        this.index.maybeRefreshBlocking();
    }

    private Map<Long, Bitmap> readLabelBitMapsInRange(IndexSearcher searcher, long range) throws IOException {
        HashMap<Long, Bitmap> fields = new HashMap<Long, Bitmap>();
        Term documentTerm = this.format.rangeTerm(range);
        TermQuery query = new TermQuery(documentTerm);
        FirstHitCollector hitCollector = new FirstHitCollector();
        searcher.search((Query)query, (Collector)hitCollector);
        if (hitCollector.hasMatched()) {
            Document document = searcher.doc(hitCollector.getMatchedDoc());
            for (IndexableField field : document.getFields()) {
                if (this.format.isRangeOrLabelField(field)) continue;
                Long label = Long.valueOf(field.name());
                fields.put(label, this.format.readBitmap(field));
            }
        }
        return fields;
    }

    private void flush() throws IOException {
        if (this.currentRange < 0L) {
            return;
        }
        IndexPartition partition = this.getCurrentPartition();
        try (PartitionSearcher partitionSearcher = partition.acquireSearcher();){
            IndexSearcher searcher = partitionSearcher.getIndexSearcher();
            Map<Long, Bitmap> fields = this.readLabelBitMapsInRange(searcher, this.currentRange);
            this.updateFields(this.updates, fields);
            Document document = new Document();
            this.format.addRangeValuesField(document, this.currentRange);
            for (Map.Entry<Long, Bitmap> field : fields.entrySet()) {
                Bitmap value = field.getValue();
                if (!value.hasContent()) continue;
                this.format.addLabelAndSearchFields(document, field.getKey(), value);
            }
            if (this.isEmpty(document)) {
                partition.getIndexWriter().deleteDocuments(new Term[]{this.format.rangeTerm(document)});
            } else {
                partition.getIndexWriter().updateDocument(this.format.rangeTerm(document), (Iterable)document);
            }
            this.updates.clear();
        }
    }

    private IndexPartition getCurrentPartition() throws IOException {
        int partition = this.getPartitionForRange();
        while (this.isNotEnoughPartitions(partition)) {
            this.index.addNewPartition();
        }
        return this.index.getPartitions().get(partition);
    }

    private boolean isNotEnoughPartitions(int partition) {
        return this.index.getPartitions().size() < partition + 1;
    }

    private int getPartitionForRange() {
        return Math.toIntExact(this.currentRange / (long)this.MAXIMUM_PARTITION_SIZE.intValue());
    }

    private boolean isEmpty(Document document) {
        for (IndexableField fieldable : document.getFields()) {
            if (this.format.isRangeOrLabelField(fieldable)) continue;
            return false;
        }
        return true;
    }

    private void updateFields(Iterable<NodeLabelUpdate> updates, Map<Long, Bitmap> fields) {
        for (NodeLabelUpdate update : updates) {
            this.clearLabels(fields, update);
            this.setLabels(fields, update);
        }
    }

    private void clearLabels(Map<Long, Bitmap> fields, NodeLabelUpdate update) {
        for (Bitmap bitmap : fields.values()) {
            this.format.bitmapFormat().set(bitmap, update.getNodeId(), false);
        }
    }

    private void setLabels(Map<Long, Bitmap> fields, NodeLabelUpdate update) {
        for (long label : update.getLabelsAfter()) {
            Bitmap bitmap = fields.get(label);
            if (bitmap == null) {
                bitmap = new Bitmap();
                fields.put(label, bitmap);
            }
            this.format.bitmapFormat().set(bitmap, update.getNodeId(), true);
        }
    }
}

