/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan.reader;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.labelscan.reader.SimpleLuceneLabelScanStoreReader;
import org.neo4j.kernel.api.impl.labelscan.storestrategy.LabelScanStorageStrategy;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.storageengine.api.schema.LabelScanReader;

public class PartitionedLuceneLabelScanStoreReader
implements LabelScanReader {
    private final List<LabelScanReader> storeReaders;

    public PartitionedLuceneLabelScanStoreReader(List<PartitionSearcher> searchers, LabelScanStorageStrategy storageStrategy) {
        this(searchers.stream().map(searcher -> new SimpleLuceneLabelScanStoreReader((PartitionSearcher)searcher, storageStrategy)).collect(Collectors.toList()));
    }

    PartitionedLuceneLabelScanStoreReader(List<LabelScanReader> readers) {
        this.storeReaders = readers;
    }

    public PrimitiveLongIterator nodesWithLabel(int labelId) {
        return this.partitionedOperation(storeReader -> storeReader.nodesWithLabel(labelId));
    }

    public PrimitiveLongIterator labelsForNode(long nodeId) {
        return this.partitionedOperation(storeReader -> storeReader.labelsForNode(nodeId));
    }

    public void close() {
        try {
            IOUtils.closeAll(this.storeReaders);
        }
        catch (IOException e) {
            throw new IndexReaderCloseException(e);
        }
    }

    private PrimitiveLongIterator partitionedOperation(Function<LabelScanReader, PrimitiveLongIterator> readerFunction) {
        return PrimitiveLongCollections.concat(this.storeReaders.parallelStream().map(readerFunction::apply).iterator());
    }
}

