/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.backup;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.apache.lucene.store.Directory;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.api.impl.index.backup.SnapshotReleaseException;
import org.neo4j.kernel.api.impl.index.backup.UnsupportedIndexDeletionPolicy;

public class LuceneIndexSnapshotFileIterator
extends PrefetchingIterator<File>
implements ResourceIterator<File> {
    private final File indexDirectory;
    private final SnapshotDeletionPolicy snapshotDeletionPolicy;
    private final Iterator<String> fileNames;
    private final IndexCommit snapshot;

    public static ResourceIterator<File> forIndex(File indexFolder, IndexWriter indexWriter) throws IOException {
        IndexDeletionPolicy deletionPolicy = indexWriter.getConfig().getIndexDeletionPolicy();
        if (deletionPolicy instanceof SnapshotDeletionPolicy) {
            SnapshotDeletionPolicy policy = (SnapshotDeletionPolicy)deletionPolicy;
            return LuceneIndexSnapshotFileIterator.hasCommits(indexWriter) ? new LuceneIndexSnapshotFileIterator(indexFolder, policy) : Iterators.emptyIterator();
        }
        throw new UnsupportedIndexDeletionPolicy("Can't perform index snapshot with specified index deleiton policy: " + deletionPolicy.getClass().getName() + ". " + "Only " + SnapshotDeletionPolicy.class.getName() + " is " + "supported");
    }

    private LuceneIndexSnapshotFileIterator(File indexDirectory, SnapshotDeletionPolicy snapshotDeletionPolicy) throws IOException {
        this.snapshot = snapshotDeletionPolicy.snapshot();
        this.indexDirectory = indexDirectory;
        this.snapshotDeletionPolicy = snapshotDeletionPolicy;
        this.fileNames = this.snapshot.getFileNames().iterator();
    }

    protected File fetchNextOrNull() {
        if (!this.fileNames.hasNext()) {
            return null;
        }
        return new File(this.indexDirectory, this.fileNames.next());
    }

    public void close() {
        try {
            this.snapshotDeletionPolicy.release(this.snapshot);
        }
        catch (IOException e) {
            throw new SnapshotReleaseException("Unable to release lucene index snapshot for index in: " + this.indexDirectory, e);
        }
    }

    private static boolean hasCommits(IndexWriter indexWriter) throws IOException {
        Directory directory = indexWriter.getDirectory();
        return DirectoryReader.indexExists((Directory)directory) && SegmentInfos.readLatestCommit((Directory)directory) != null;
    }
}

