/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import org.apache.lucene.util.VectorUtil;
import org.neo4j.kernel.api.vector.VectorSimilarityFunction;
import org.neo4j.values.VectorCandidate;

public enum Neo4jVectorSimilarityFunction implements VectorSimilarityFunction
{
    EUCLIDEAN("EUCLIDEAN", "Vector must only contain finite values"){

        public float[] maybeToValidVector(VectorCandidate candidate) {
            if (candidate == null || candidate.dimensions() == 0) {
                return null;
            }
            int dimensions = candidate.dimensions();
            float[] vector = new float[dimensions];
            for (int i = 0; i < dimensions; ++i) {
                float element = candidate.floatValue(i);
                if (!Float.isFinite(element)) {
                    return null;
                }
                vector[i] = element;
            }
            return vector;
        }

        public float compare(float[] vector1, float[] vector2) {
            return 1.0f / (1.0f + VectorUtil.squareDistance((float[])vector1, (float[])vector2));
        }
    }
    ,
    SIMPLE_COSINE("COSINE", "Vector must only contain finite values, and have positive and finite l2-norm"){

        public float[] maybeToValidVector(VectorCandidate candidate) {
            if (candidate == null || candidate.dimensions() == 0) {
                return null;
            }
            int dimensions = candidate.dimensions();
            float square = 0.0f;
            float[] vector = new float[dimensions];
            for (int i = 0; i < dimensions; ++i) {
                float element = candidate.floatValue(i);
                if (!Float.isFinite(element)) {
                    return null;
                }
                square += element * element;
                vector[i] = element;
            }
            if (square <= 0.0f || !Float.isFinite(square)) {
                return null;
            }
            return vector;
        }

        public float compare(float[] vector1, float[] vector2) {
            return Math.max((1.0f + VectorUtil.cosine((float[])vector1, (float[])vector2)) / 2.0f, 0.0f);
        }
    }
    ,
    L2_NORM_COSINE("COSINE", "Vector must only contain finite values, and have positive and finite l2-norm"){

        public float[] maybeToValidVector(VectorCandidate candidate) {
            double scale;
            if (candidate == null || candidate.dimensions() == 0) {
                return null;
            }
            int dimensions = candidate.dimensions();
            double square = 0.0;
            for (int i = 0; i < dimensions; ++i) {
                double element = candidate.doubleValue(i);
                if (!Double.isFinite(element)) {
                    return null;
                }
                square += element * element;
            }
            if (square <= 0.0 || !Double.isFinite(square) || !Double.isFinite(scale = 1.0 / Math.sqrt(square))) {
                return null;
            }
            float[] vector = new float[dimensions];
            for (int i = 0; i < dimensions; ++i) {
                float element = (float)(candidate.doubleValue(i) * scale);
                if (!Float.isFinite(element)) {
                    return null;
                }
                vector[i] = element;
            }
            return vector;
        }

        public float compare(float[] vector1, float[] vector2) {
            return Math.max((1.0f + VectorUtil.dotProduct((float[])vector1, (float[])vector2)) / 2.0f, 0.0f);
        }
    };

    private final String functionName;
    private final String invalidReason;

    private Neo4jVectorSimilarityFunction(String functionName, String invalidReason) {
        this.functionName = functionName;
        this.invalidReason = invalidReason;
    }

    public String functionName() {
        return this.functionName;
    }

    public float[] toValidVector(VectorCandidate candidate) {
        float[] vector = this.maybeToValidVector(candidate);
        if (vector == null) {
            throw new IllegalArgumentException(this.invalidReason + ". Provided: " + String.valueOf(candidate));
        }
        return vector;
    }
}

