/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocumentsFactory;
import org.neo4j.kernel.api.impl.schema.writer.LucenePartitionIndexWriter;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;

public class TextIndexPopulatingUpdater
implements IndexUpdater {
    private final LucenePartitionIndexWriter writer;
    private final IndexUpdateIgnoreStrategy ignoreStrategy;
    private final LuceneDocumentsFactory documentsFactory;

    public TextIndexPopulatingUpdater(LucenePartitionIndexWriter writer, IndexUpdateIgnoreStrategy ignoreStrategy) {
        this.writer = writer;
        this.ignoreStrategy = ignoreStrategy;
        this.documentsFactory = writer.documentsFactory();
    }

    public void close() {
    }

    public void process(IndexEntryUpdate update) {
        ValueIndexEntryUpdate valueUpdate = this.asValueUpdate(update);
        if (valueUpdate == null) {
            return;
        }
        try {
            long entityId = valueUpdate.getEntityId();
            Object[] values = valueUpdate.values();
            UpdateMode updateMode = valueUpdate.updateMode();
            switch (updateMode) {
                case ADDED: {
                    this.writer.updateDocument("id", entityId, this.documentsFactory.reusableTextDocument(entityId, (Value[])values));
                    break;
                }
                case CHANGED: {
                    this.writer.updateOrDeleteDocument("id", entityId, this.documentsFactory.reusableTextDocument(entityId, (Value[])values));
                    break;
                }
                case REMOVED: {
                    this.writer.deleteDocuments("id", entityId);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown update mode " + String.valueOf(updateMode) + " for values " + Arrays.toString(values));
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ValueIndexEntryUpdate asValueUpdate(IndexEntryUpdate update) {
        ValueIndexEntryUpdate valueUpdate = super.asValueUpdate(update);
        return !this.ignoreStrategy.ignore(valueUpdate) ? this.ignoreStrategy.toEquivalentUpdate(valueUpdate) : null;
    }
}

