/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import org.neo4j.kernel.api.impl.index.lucene.LuceneDocumentsFactory;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexSearcher;
import org.neo4j.kernel.api.impl.index.lucene.LuceneQueryContext;
import org.neo4j.values.storable.Value;

public class TextDocumentStructure {
    private TextDocumentStructure() {
    }

    public static LuceneQueryContext newSeekQuery(LuceneIndexSearcher searcher, Value ... values) {
        LuceneQueryContext queryContext = searcher.newQueryContext();
        TextDocumentStructure.seekStrings(values, queryContext);
        return queryContext;
    }

    public static void seekStrings(Value[] values, LuceneQueryContext queryContext) {
        for (int i = 0; i < values.length; ++i) {
            queryContext.addConstantMustTerm(LuceneDocumentsFactory.textValueKey(i), values[i].asObject().toString());
        }
    }

    public static boolean useFieldForUniquenessVerification(String fieldName) {
        return !"id".equals(fieldName) && LuceneDocumentsFactory.isFirstTextProperty(fieldName);
    }
}

