/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexSearcher;
import org.neo4j.kernel.api.impl.index.lucene.LuceneQueryContext;
import org.neo4j.kernel.api.impl.schema.LuceneQueryFactory;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.kernel.impl.index.schema.PartitionedValueSeek;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public abstract class AbstractLuceneIndexReader
implements ValueIndexReader {
    private final IndexUsageTracking usageTracker;
    private final LuceneQueryFactory queryFactory;
    protected final IndexDescriptor descriptor;
    protected final Log log;

    public AbstractLuceneIndexReader(IndexDescriptor descriptor, IndexUsageTracking usageTracker, LuceneQueryFactory queryFactory, LogProvider logProvider) {
        this.descriptor = descriptor;
        this.usageTracker = usageTracker;
        this.queryFactory = queryFactory;
        this.log = logProvider.getLog(this.getClass());
    }

    public void query(IndexProgressor.EntityValueClient client, QueryContext queryContext, CursorContext cursorContext, IndexQueryConstraints constraints, PropertyIndexQuery ... predicates) throws IndexNotApplicableKernelException {
        PropertyIndexQuery predicate = this.validateSingleQuery(constraints, predicates);
        queryContext.monitor().queried(this.descriptor);
        this.usageTracker.queried();
        IndexProgressor progressor = this.indexProgressor(this.queryFactory, predicate, constraints, client);
        boolean needStoreFilter = this.needStoreFilter(predicate);
        client.initializeQuery(this.descriptor, progressor, false, needStoreFilter, constraints, new PropertyIndexQuery[]{predicate});
    }

    public void validateQuery(IndexQueryConstraints constraints, PropertyIndexQuery ... predicates) throws IndexNotApplicableKernelException {
        if (predicates.length > 1) {
            throw this.invalidCompositeQuery(msg -> IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)this.descriptor.getName(), (String)msg), predicates);
        }
        PropertyIndexQuery predicate = predicates[0];
        if (!this.descriptor.getCapability().isQuerySupported(predicate.type(), predicate.valueCategory())) {
            throw this.invalidQuery(msg -> IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)this.descriptor.getName(), (String)msg), predicate);
        }
    }

    protected PropertyIndexQuery validateSingleQuery(IndexQueryConstraints constraints, PropertyIndexQuery ... predicates) throws IndexNotApplicableKernelException {
        this.validateQuery(constraints, predicates);
        return predicates[0];
    }

    protected <E extends Exception> E invalidCompositeQuery(Function<String, E> constructor, PropertyIndexQuery ... predicates) {
        IndexType indexType = this.descriptor.getIndexType();
        return (E)((Exception)constructor.apply("Tried to query a %s index with a composite query. Composite queries are not supported by a %s index. Query was: %s ".formatted(indexType, indexType, Arrays.toString(predicates))));
    }

    protected <E extends Exception> E invalidQuery(Function<String, E> constructor, PropertyIndexQuery predicate) {
        IndexType indexType = this.descriptor.getIndexType();
        return (E)((Exception)constructor.apply("Index query not supported for %s index. Query: %s".formatted(indexType, predicate)));
    }

    protected abstract IndexProgressor indexProgressor(LuceneQueryFactory var1, PropertyIndexQuery var2, IndexQueryConstraints var3, IndexProgressor.EntityValueClient var4);

    protected abstract String entityIdFieldKey();

    protected abstract boolean needStoreFilter(PropertyIndexQuery var1);

    public PartitionedValueSeek valueSeek(int desiredNumberOfPartitions, QueryContext context, PropertyIndexQuery ... query) {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    protected BoundedIterable<Long> newAllEntriesValueReaderForPartition(String field, LuceneIndexSearcher searcher, LuceneQueryContext queryContext, long fromIdInclusive, long toIdExclusive) {
        try {
            LuceneIndexSearcher.InRangeEntityConsumer entityConsumer = new LuceneIndexSearcher.InRangeEntityConsumer(fromIdInclusive, toIdExclusive);
            IndexProgressor indexProgressor = searcher.searchDocValues(queryContext, field, entityConsumer);
            return new AllEntriesValueReaderForPartition(indexProgressor, entityConsumer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected final String indexName() {
        return this.descriptor.getName();
    }

    public IndexUsageTracking usageTracking() {
        return this.usageTracker;
    }

    private record AllEntriesValueReaderForPartition(IndexProgressor indexProgressor, LuceneIndexSearcher.InRangeEntityConsumer entityConsumer) implements BoundedIterable<Long>
    {
        public Iterator<Long> iterator() {
            return new PrefetchingIterator<Long>(){

                protected Long fetchNextOrNull() {
                    return indexProgressor.next() ? Long.valueOf(entityConsumer.reference()) : null;
                }
            };
        }

        public long maxCount() {
            return -1L;
        }

        public void close() {
            this.indexProgressor.close();
        }
    }
}

