/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.storage;

import java.nio.file.Path;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;

public class IndexStorageFactory
implements AutoCloseable {
    private final DirectoryFactory dirFactory;
    private final FileSystemAbstraction fileSystem;
    private final IndexDirectoryStructure structure;

    public IndexStorageFactory(DirectoryFactory dirFactory, FileSystemAbstraction fileSystem, IndexDirectoryStructure structure) {
        this.dirFactory = dirFactory;
        this.fileSystem = fileSystem;
        this.structure = structure;
    }

    public PartitionedIndexStorage indexStorageOf(long indexId) {
        Path rootFolder = this.structure.directoryForIndex(indexId);
        return new PartitionedIndexStorage(this.dirFactory.getContext(), this.dirFactory, this.fileSystem, rootFolder);
    }

    @Override
    public void close() throws Exception {
        this.dirFactory.close();
    }
}

