/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v9;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.neo4j.internal.helpers.CancellationRequest;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexSampler;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9IndexSearcher;
import org.neo4j.kernel.api.impl.schema.TaskCoordinator;
import org.neo4j.kernel.api.impl.schema.populator.DefaultNonUniqueIndexSampler;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;

class Lucene9IndexSampler
implements LuceneIndexSampler {
    private final Lucene9IndexSearcher indexSearcher;
    private final IndexSamplingConfig indexSamplingConfig;
    private final TaskCoordinator taskCoordinator;

    Lucene9IndexSampler(Lucene9IndexSearcher indexSearcher, TaskCoordinator taskCoordinator, IndexSamplingConfig indexSamplingConfig) {
        this.taskCoordinator = taskCoordinator;
        this.indexSearcher = indexSearcher;
        this.indexSamplingConfig = indexSamplingConfig;
    }

    static void checkCancellation(CancellationRequest ongoingTask) throws IndexNotFoundKernelException {
        if (ongoingTask.cancellationRequested()) {
            throw IndexNotFoundKernelException.indexDroppedWhileSampling();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IndexSample sampleIndex(CursorContext cursorContext, AtomicBoolean stopped) throws IndexNotFoundKernelException {
        try (TaskCoordinator.Task task = this.newTask();){
            DefaultNonUniqueIndexSampler sampler = new DefaultNonUniqueIndexSampler(this.indexSamplingConfig.sampleSizeLimit());
            IndexReader indexReader = this.indexSearcher.getIndexReader();
            for (LeafReaderContext readerContext : indexReader.leaves()) {
                try {
                    Set<String> fieldNames = Lucene9IndexSampler.getFieldNamesToSample(readerContext);
                    for (String fieldName : fieldNames) {
                        BytesRef termsRef;
                        Terms terms = readerContext.reader().terms(fieldName);
                        if (terms == null) continue;
                        TermsEnum termsEnum = terms.iterator();
                        while ((termsRef = termsEnum.next()) != null) {
                            sampler.include(termsRef.utf8ToString(), termsEnum.docFreq());
                            Lucene9IndexSampler.checkCancellation(task);
                            if (!stopped.get()) continue;
                            IndexSample indexSample = new IndexSample();
                            return indexSample;
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            IndexSample indexSample = sampler.sample(indexReader.numDocs(), cursorContext);
            return indexSample;
        }
    }

    private static Set<String> getFieldNamesToSample(LeafReaderContext readerContext) {
        HashSet<String> fieldNames = new HashSet<String>();
        LeafReader reader = readerContext.reader();
        reader.getFieldInfos().forEach(info -> {
            String name = info.name;
            if (!"id".equals(name)) {
                fieldNames.add(name);
            }
        });
        return fieldNames;
    }

    @Override
    public TaskCoordinator.Task newTask() throws IndexNotFoundKernelException {
        Lucene9IndexSampler.checkCancellation(this.taskCoordinator);
        return this.taskCoordinator.newTask();
    }
}

