/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDirectory;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDirectoryReader;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocument;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocumentsFactory;

public interface LuceneIndexWriter
extends Closeable {
    public static final int MAX_DOCS = 0x7FFFFF7F;
    public static final int MAX_TERM_LENGTH = 32766;
    public static final String WRITE_LOCK_NAME = "write.lock";
    public static final String KEY_STATUS = "status";
    public static final String ONLINE = "online";
    public static final Set<Map.Entry<String, String>> ONLINE_COMMIT_USER_DATA = Set.of(Map.entry("status", "online"));

    public LuceneDocument newDocument();

    public void addDocument(LuceneDocument var1) throws IOException;

    public void addDocuments(Iterable<LuceneDocument> var1) throws IOException;

    public void updateDocument(String var1, long var2, LuceneDocument var4) throws IOException;

    public void deleteDocuments(String var1, long var2) throws IOException;

    public void commit() throws IOException;

    public void rollback() throws IOException;

    public LuceneDirectoryReader directoryReader() throws IOException;

    public boolean hasCommits() throws IOException;

    public void forceMerge(int var1) throws IOException;

    public void markAsOnline();

    public int getMaxDocs();

    public void addIndexes(LuceneDirectory var1) throws IOException;

    public ResourceIterator<Path> snapshot(Path var1) throws IOException;

    public LuceneDocumentsFactory documentFactory();
}

