/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import org.neo4j.kernel.api.impl.schema.vector.VectorDocumentStructure;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexVersion;

class VectorDocumentStructures {
    private static final VectorDocumentStructure V1 = new VectorDocumentStructure(){
        static final String VECTOR_VALUE_KEY = "vector";

        @Override
        public String vectorValueKeyFor(int dimensions) {
            return VECTOR_VALUE_KEY;
        }
    };
    private static final VectorDocumentStructure V2 = new VectorDocumentStructure(){
        static final String VECTOR_VALUE_KEY_SUFFIX = "d-vector";

        @Override
        public String vectorValueKeyFor(int dimensions) {
            return dimensions + VECTOR_VALUE_KEY_SUFFIX;
        }
    };

    VectorDocumentStructures() {
    }

    static VectorDocumentStructure documentStructureFor(VectorIndexVersion version) {
        return switch (version) {
            default -> throw new MatchException(null, null);
            case VectorIndexVersion.UNKNOWN -> null;
            case VectorIndexVersion.V1_0 -> V1;
            case VectorIndexVersion.V2_0 -> V2;
        };
    }
}

