/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.storage;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDirectory;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDirectoryFactory;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9DirectoryFactory;

public interface DirectoryFactory
extends AutoCloseable {
    public static final LuceneDirectoryFactory CURRENT = Lucene9DirectoryFactory.INSTANCE;
    public static final DirectoryFactory PERSISTENT = new PersistentDirectoryFactory(CURRENT);

    public LuceneDirectory open(Path var1) throws IOException;

    public static DirectoryFactory directoryFactory(FileSystemAbstraction fs) {
        return fs.isPersistent() ? PERSISTENT : CURRENT.newInMemoryDirectoryFactory(fs);
    }

    public static DirectoryFactory inMemory() {
        return CURRENT.newInMemoryDirectoryFactory();
    }

    public static DirectoryFactory inMemory(FileSystemAbstraction fs) {
        return CURRENT.newInMemoryDirectoryFactory(fs);
    }

    public static class PersistentDirectoryFactory
    extends FallbackDirectoryFactory {
        PersistentDirectoryFactory(LuceneDirectoryFactory ... directoryFactories) {
            super(directoryFactories);
        }

        @Override
        protected LuceneDirectory actualOpen(LuceneDirectoryFactory directoryFactory, Path dir) throws IOException {
            return directoryFactory.openPersistent(dir);
        }
    }

    public static abstract class FallbackDirectoryFactory
    implements DirectoryFactory {
        private final LuceneDirectoryFactory[] directoryFactories;

        FallbackDirectoryFactory(LuceneDirectoryFactory ... directoryFactories) {
            this.directoryFactories = directoryFactories;
        }

        @Override
        public LuceneDirectory open(Path dir) throws IOException {
            for (LuceneDirectoryFactory directoryFactory : this.directoryFactories) {
                LuceneDirectory directory = this.actualOpen(directoryFactory, dir);
                if (!directory.indexExists() || directory.validVersion()) {
                    return directory;
                }
                directory.close();
            }
            throw new IOException("No compatible reader for index in " + String.valueOf(dir) + " found.");
        }

        protected abstract LuceneDirectory actualOpen(LuceneDirectoryFactory var1, Path var2) throws IOException;

        @Override
        public void close() throws IOException {
            IOUtils.closeAll((AutoCloseable[])this.directoryFactories);
        }
    }
}

