/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v9;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.KnnFloatVectorField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocument;
import org.neo4j.kernel.api.impl.schema.vector.Neo4jVectorSimilarityFunction;

class Lucene9Document
implements LuceneDocument {
    final Document document;

    Lucene9Document() {
        this(new Document());
    }

    Lucene9Document(Document document) {
        this.document = document;
    }

    @Override
    public void addNumericField(String key, long value) {
        this.document.add((IndexableField)new NumericDocValuesField(key, value));
    }

    @Override
    public void addStringField(String key, String string, boolean store) {
        this.document.add((IndexableField)new StringField(key, string, store ? Field.Store.YES : Field.Store.NO));
    }

    @Override
    public void addTextField(String key, String textValue, boolean store) {
        this.document.add((IndexableField)new TextField(key, textValue, store ? Field.Store.YES : Field.Store.NO));
    }

    @Override
    public void addKnnFloatVectorField(String key, float[] vector, Neo4jVectorSimilarityFunction similarityFunction) {
        this.document.add((IndexableField)new KnnFloatVectorField(key, vector, Lucene9Document.toLucene(similarityFunction)));
    }

    @Override
    public String get(String key) {
        return this.document.get(key);
    }

    private static VectorSimilarityFunction toLucene(Neo4jVectorSimilarityFunction similarityFunction) {
        return switch (similarityFunction) {
            default -> throw new MatchException(null, null);
            case Neo4jVectorSimilarityFunction.EUCLIDEAN -> VectorSimilarityFunction.EUCLIDEAN;
            case Neo4jVectorSimilarityFunction.SIMPLE_COSINE -> VectorSimilarityFunction.COSINE;
            case Neo4jVectorSimilarityFunction.L2_NORM_COSINE -> VectorSimilarityFunction.DOT_PRODUCT;
        };
    }
}

