/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene;

import org.neo4j.kernel.api.impl.index.lucene.LuceneDocument;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9DocumentsFactory;
import org.neo4j.kernel.api.impl.schema.vector.Neo4jVectorSimilarityFunction;
import org.neo4j.kernel.api.impl.schema.vector.VectorDocumentStructure;
import org.neo4j.values.VectorCandidate;
import org.neo4j.values.storable.Value;

public interface LuceneDocumentsFactory {
    public static final LuceneDocumentsFactory CURRENT = Lucene9DocumentsFactory.INSTANCE;
    public static final String ENTITY_ID_KEY = "id";
    public static final String TEXT_VALUE_KEY_SUFFIX = "string";
    public static final String TRIGRAM_VALUE_KEY = "0";

    public static String textValueKey(int propertyNumber) {
        if (propertyNumber == 0) {
            return TEXT_VALUE_KEY_SUFFIX;
        }
        return propertyNumber + TEXT_VALUE_KEY_SUFFIX;
    }

    public static boolean isFirstTextProperty(String fieldName) {
        return !Character.isDigit(fieldName.charAt(0));
    }

    public static long getEntityId(LuceneDocument document) {
        return Long.parseLong(document.get(ENTITY_ID_KEY));
    }

    public LuceneDocument reusableTextDocument(long var1, Value ... var3);

    public LuceneDocument reusableFulltextDocument(long var1, String[] var3, Value[] var4);

    public LuceneDocument createTrigramDocument(long var1, Value var3);

    public LuceneDocument createVectorDocument(VectorDocumentStructure var1, long var2, VectorCandidate var4, Neo4jVectorSimilarityFunction var5);

    public LuceneDocument newDocument();
}

