/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.collector;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.function.LongPredicate;
import org.neo4j.kernel.api.impl.index.collector.ValuesIterator;

public class ScoredEntityIterator
implements ValuesIterator {
    private final ValuesIterator iterator;
    private final LongPredicate predicate;
    private boolean hasNext;
    private long currentEntityId;
    private float currentScore;
    private long nextEntityId;
    private float nextScore;

    private ScoredEntityIterator(ValuesIterator sortedValuesIterator, LongPredicate predicate) {
        this.iterator = sortedValuesIterator;
        this.predicate = predicate;
        this.advanceIterator();
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public long current() {
        return this.currentEntityId;
    }

    @Override
    public int remaining() {
        return this.iterator.remaining() + (this.hasNext ? 1 : 0);
    }

    @Override
    public float currentScore() {
        return this.currentScore;
    }

    public long next() {
        if (this.hasNext) {
            this.currentEntityId = this.nextEntityId;
            this.currentScore = this.nextScore;
            this.advanceIterator();
            return this.currentEntityId;
        }
        throw new NoSuchElementException("The iterator is exhausted.");
    }

    private void advanceIterator() {
        do {
            this.hasNext = this.iterator.hasNext();
            if (!this.hasNext) continue;
            this.nextEntityId = this.iterator.next();
            this.nextScore = this.iterator.currentScore();
        } while (this.hasNext && !this.predicate.test(this.nextEntityId));
    }

    public static ValuesIterator filter(ValuesIterator iterator, LongPredicate predicate) {
        return new ScoredEntityIterator(iterator, predicate);
    }

    public static ValuesIterator mergeIterators(List<ValuesIterator> iterators) {
        if (iterators.size() == 1) {
            return iterators.getFirst();
        }
        return new ConcatenatingScoredEntityIterator(iterators);
    }

    private static class ConcatenatingScoredEntityIterator
    implements ValuesIterator {
        private final PriorityQueue<ValuesIterator> sources = new PriorityQueue((o1, o2) -> Float.compare(o2.currentScore(), o1.currentScore()));
        private boolean hasNext;
        private long entityId;
        private float score;

        ConcatenatingScoredEntityIterator(Iterable<? extends ValuesIterator> iterators) {
            for (ValuesIterator valuesIterator : iterators) {
                if (!valuesIterator.hasNext()) continue;
                valuesIterator.next();
                this.sources.add(valuesIterator);
                this.hasNext = true;
            }
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public int remaining() {
            return 0;
        }

        @Override
        public float currentScore() {
            return this.score;
        }

        public long next() {
            if (this.hasNext) {
                ValuesIterator iterator = this.sources.poll();
                assert (iterator != null);
                this.entityId = iterator.current();
                this.score = iterator.currentScore();
                if (iterator.hasNext()) {
                    iterator.next();
                    this.sources.add(iterator);
                }
                this.hasNext = !this.sources.isEmpty();
                return this.entityId;
            }
            throw new NoSuchElementException();
        }

        @Override
        public long current() {
            return this.entityId;
        }
    }
}

