/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.trigram;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.lucene.LuceneQueryContext;
import org.neo4j.kernel.api.impl.schema.AbstractTextIndexReader;
import org.neo4j.kernel.api.impl.schema.LuceneQueryFactory;
import org.neo4j.kernel.api.impl.schema.trigram.TrigramIndexSampler;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.logging.LogProvider;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;

public class TrigramIndexReader
extends AbstractTextIndexReader {
    TrigramIndexReader(SearcherReference searcherReference, IndexDescriptor descriptor, IndexUsageTracking usageTracker, LogProvider logProvider) {
        super(descriptor, searcherReference, usageTracker, LuceneQueryFactory.TrigramQueryFactory.INSTANCE, logProvider);
    }

    public IndexSampler createSampler() {
        return new TrigramIndexSampler(this.getIndexSearcher());
    }

    @Override
    protected String entityIdFieldKey() {
        return "id";
    }

    @Override
    protected boolean needStoreFilter(PropertyIndexQuery predicate) {
        return !predicate.type().equals((Object)IndexQuery.IndexQueryType.ALL_ENTRIES);
    }

    public long countIndexedEntities(long entityId, CursorContext cursorContext, int[] propertyKeyIds, Value ... propertyValues) {
        LuceneQueryContext queryContext = this.getIndexSearcher().newQueryContext();
        queryContext.addMustTerm("id", String.valueOf(entityId));
        Preconditions.checkState((propertyKeyIds.length == 1 ? 1 : 0) != 0, (String)"Text index does not support composite indexing. Tried to query index with multiple property keys.");
        String value = propertyValues[0].asObject().toString();
        queryContext.addExactTrigram(value);
        try {
            return this.getIndexSearcher().count(queryContext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    BoundedIterable<Long> newAllEntriesValueReader(long fromIdInclusive, long toIdExclusive) throws IOException {
        return this.newAllEntriesValueReaderForPartition("id", this.getIndexSearcher(), this.getIndexSearcher().newQueryContext().matchAll(), fromIdInclusive, toIdExclusive);
    }
}

