/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.trigram;

import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocument;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocumentsFactory;
import org.neo4j.kernel.api.impl.schema.populator.LuceneIndexPopulator;
import org.neo4j.kernel.api.impl.schema.trigram.TrigramIndexPopulatingUpdater;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.IndexValueValidator;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;

class TrigramIndexPopulator
extends LuceneIndexPopulator<DatabaseIndex<ValueIndexReader>> {
    private final IndexValueValidator validator;

    TrigramIndexPopulator(DatabaseIndex<ValueIndexReader> luceneIndex, IndexUpdateIgnoreStrategy ignoreStrategy, IndexValueValidator validator) {
        super(luceneIndex, ignoreStrategy);
        this.validator = validator;
    }

    @Override
    protected LuceneDocument updateAsDocument(ValueIndexEntryUpdate update) {
        long entityId = update.getEntityId();
        Value value = update.values()[0];
        this.validator.validate(entityId, new Value[]{value});
        return LuceneDocumentsFactory.CURRENT.createTrigramDocument(entityId, value);
    }

    public IndexUpdater newPopulatingUpdater(CursorContext cursorContext) {
        return new TrigramIndexPopulatingUpdater(this.writer, this.ignoreStrategy, this.validator);
    }
}

