/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.trigram;

import java.util.function.Supplier;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigBuilder;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigMode;
import org.neo4j.kernel.api.impl.index.WritableDatabaseIndex;
import org.neo4j.kernel.api.impl.index.builder.AbstractLuceneIndexBuilder;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexWriterConfig;
import org.neo4j.kernel.api.impl.index.partition.WritableIndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.trigram.TrigramIndex;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.logging.LogProvider;

public class TrigramIndexBuilder
extends AbstractLuceneIndexBuilder<TrigramIndexBuilder> {
    private final IndexDescriptor descriptor;
    private final Config config;
    private Supplier<LuceneIndexWriterConfig> writerConfigFactory;

    private TrigramIndexBuilder(IndexDescriptor descriptor, DatabaseReadOnlyChecker readOnlyChecker, Config config, LogProvider logProvider) {
        super(readOnlyChecker, logProvider);
        this.descriptor = descriptor;
        this.config = config;
        IndexWriterConfigBuilder writerConfigBuilder = new IndexWriterConfigBuilder(IndexWriterConfigMode.TEXT, config);
        this.writerConfigFactory = writerConfigBuilder::build;
    }

    public static TrigramIndexBuilder create(IndexDescriptor descriptor, DatabaseReadOnlyChecker readOnlyChecker, Config config, LogProvider logProvider) {
        return new TrigramIndexBuilder(descriptor, readOnlyChecker, config, logProvider);
    }

    TrigramIndexBuilder withWriterConfig(Supplier<LuceneIndexWriterConfig> writerConfigFactory) {
        this.writerConfigFactory = writerConfigFactory;
        return this;
    }

    public DatabaseIndex<ValueIndexReader> build() {
        PartitionedIndexStorage storage = this.storageBuilder.build();
        TrigramIndex index = new TrigramIndex(storage, this.descriptor, new WritableIndexPartitionFactory(this.writerConfigFactory), this.config, this.logProvider);
        return new WritableDatabaseIndex(index, this.readOnlyChecker, this.permanentlyReadOnly);
    }
}

