/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import org.neo4j.configuration.Config;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexWriterConfig;
import org.neo4j.kernel.api.impl.index.lucene.LuceneSettings;

public enum IndexWriterConfigMode {
    VECTOR(false, LuceneSettings.lucene_writer_max_buffered_docs, LuceneSettings.lucene_standard_ram_buffer_size, LuceneSettings.vector_standard_merge_factor),
    VECTOR_POPULATION(true, LuceneSettings.lucene_population_max_buffered_docs, LuceneSettings.vector_population_ram_buffer_size, LuceneSettings.vector_population_merge_factor),
    TEXT(false, LuceneSettings.lucene_writer_max_buffered_docs, LuceneSettings.lucene_standard_ram_buffer_size, LuceneSettings.lucene_merge_factor),
    TEXT_POPULATION(true, LuceneSettings.lucene_population_max_buffered_docs, LuceneSettings.lucene_population_ram_buffer_size, LuceneSettings.lucene_merge_factor),
    TRANSACTION_STATE(false, (Setting)LuceneSettings.lucene_writer_max_buffered_docs, (Setting)LuceneSettings.lucene_standard_ram_buffer_size, (Setting)LuceneSettings.lucene_merge_factor){

        @Override
        public LuceneIndexWriterConfig visitWithConfig(LuceneIndexWriterConfig writerConfig, Config config) {
            return super.visitWithConfig(writerConfig, config).setCommitOnClose(false);
        }
    };

    private final boolean forPopulation;
    private final Setting<Integer> maxBufferedDocsSetting;
    private final Setting<Double> ramBufferSizeMBSetting;
    private final Setting<Integer> mergeFactorSetting;

    private IndexWriterConfigMode(boolean forPopulation, Setting<Integer> maxBufferedDocsSetting, Setting<Double> RAMBufferSizeMB, Setting<Integer> mergeFactorSetting) {
        this.forPopulation = forPopulation;
        this.maxBufferedDocsSetting = maxBufferedDocsSetting;
        this.ramBufferSizeMBSetting = RAMBufferSizeMB;
        this.mergeFactorSetting = mergeFactorSetting;
    }

    public int getMergeFactor(Config config) {
        return (Integer)config.get(this.mergeFactorSetting);
    }

    public LuceneIndexWriterConfig visitWithConfig(LuceneIndexWriterConfig writerConfig, Config config) {
        writerConfig.setMaxBufferedDocs((Integer)config.get(this.maxBufferedDocsSetting)).setRAMBufferSizeMB((Double)config.get(this.ramBufferSizeMBSetting));
        if (this.forPopulation && ((Boolean)config.get(LuceneSettings.lucene_population_serial_merge_scheduler)).booleanValue()) {
            writerConfig.useOnThreadConcurrentMergeScheduler();
        }
        return writerConfig;
    }
}

