/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.IndexWriterFactory;
import org.neo4j.kernel.api.impl.index.IndexWriterStatus;
import org.neo4j.kernel.api.impl.index.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.index.LuceneIndexPopulator;
import org.neo4j.kernel.api.impl.index.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.Reservation;
import org.neo4j.kernel.api.index.util.FailureStorage;

class NonUniqueLuceneIndexPopulator
extends LuceneIndexPopulator {
    static final int DEFAULT_QUEUE_THRESHOLD = 10000;
    private final int queueThreshold;
    private final List<NodePropertyUpdate> updates = new ArrayList<NodePropertyUpdate>();

    NonUniqueLuceneIndexPopulator(int queueThreshold, LuceneDocumentStructure documentStructure, IndexWriterFactory<LuceneIndexWriter> indexWriterFactory, IndexWriterStatus writerStatus, DirectoryFactory dirFactory, File dirFile, FailureStorage failureStorage, long indexId) {
        super(documentStructure, indexWriterFactory, writerStatus, dirFactory, dirFile, failureStorage, indexId);
        this.queueThreshold = queueThreshold;
    }

    public void add(long nodeId, Object propertyValue) throws IOException, IndexCapacityExceededException {
        this.writer.addDocument(this.documentStructure.newDocumentRepresentingProperty(nodeId, propertyValue));
    }

    public void verifyDeferredConstraints(PropertyAccessor accessor) throws IndexEntryConflictException, IOException {
    }

    public IndexUpdater newPopulatingUpdater(PropertyAccessor propertyAccessor) throws IOException {
        return new IndexUpdater(){

            public Reservation validate(Iterable<NodePropertyUpdate> updates) throws IOException {
                return Reservation.EMPTY;
            }

            public void process(NodePropertyUpdate update) throws IOException, IndexEntryConflictException {
                NonUniqueLuceneIndexPopulator.this.updates.add(update);
            }

            public void close() throws IOException, IndexEntryConflictException, IndexCapacityExceededException {
                if (NonUniqueLuceneIndexPopulator.this.updates.size() > NonUniqueLuceneIndexPopulator.this.queueThreshold) {
                    NonUniqueLuceneIndexPopulator.this.flush();
                    NonUniqueLuceneIndexPopulator.this.updates.clear();
                }
            }

            public void remove(Iterable<Long> nodeIds) throws IOException {
                throw new UnsupportedOperationException("Should not remove() from populating index.");
            }
        };
    }

    @Override
    protected void flush() throws IOException, IndexCapacityExceededException {
        block4: for (NodePropertyUpdate update : this.updates) {
            long nodeId = update.getNodeId();
            switch (update.getUpdateMode()) {
                case ADDED: 
                case CHANGED: {
                    this.writer.updateDocument(this.documentStructure.newQueryForChangeOrRemove(nodeId), this.documentStructure.newDocumentRepresentingProperty(nodeId, update.getValueAfter()));
                    continue block4;
                }
                case REMOVED: {
                    this.writer.deleteDocuments(this.documentStructure.newQueryForChangeOrRemove(nodeId));
                    continue block4;
                }
            }
            throw new IllegalStateException("Unknown update mode " + update.getUpdateMode());
        }
    }
}

