/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.Directory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.api.impl.index.DeferredConstraintVerificationUniqueLuceneIndexPopulator;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.IndexWriterFactories;
import org.neo4j.kernel.api.impl.index.IndexWriterStatus;
import org.neo4j.kernel.api.impl.index.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.index.LuceneSchemaIndexProviderFactory;
import org.neo4j.kernel.api.impl.index.NonUniqueLuceneIndexAccessor;
import org.neo4j.kernel.api.impl.index.NonUniqueLuceneIndexPopulator;
import org.neo4j.kernel.api.impl.index.SearcherManagerFactories;
import org.neo4j.kernel.api.impl.index.UniqueLuceneIndexAccessor;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.index.util.FailureStorage;
import org.neo4j.kernel.api.index.util.FolderLayout;
import org.neo4j.kernel.configuration.Config;

public class LuceneSchemaIndexProvider
extends SchemaIndexProvider {
    private final DirectoryFactory directoryFactory;
    private final LuceneDocumentStructure documentStructure = new LuceneDocumentStructure();
    private final IndexWriterStatus writerStatus = new IndexWriterStatus();
    private final FailureStorage failureStorage;
    private final FolderLayout folderLayout;
    private Map<Long, String> failures = new HashMap<Long, String>();

    public LuceneSchemaIndexProvider(DirectoryFactory directoryFactory, Config config) {
        super(LuceneSchemaIndexProviderFactory.PROVIDER_DESCRIPTOR, 1);
        this.directoryFactory = directoryFactory;
        File rootDirectory = LuceneSchemaIndexProvider.getRootDirectory((File)((File)config.get(GraphDatabaseSettings.store_dir)), (String)"lucene");
        this.folderLayout = new FolderLayout(rootDirectory);
        this.failureStorage = new FailureStorage(this.folderLayout);
    }

    public IndexPopulator getPopulator(long indexId, IndexDescriptor descriptor, IndexConfiguration config) {
        if (config.isUnique()) {
            return new DeferredConstraintVerificationUniqueLuceneIndexPopulator(this.documentStructure, IndexWriterFactories.tracking(), SearcherManagerFactories.standard(), this.writerStatus, this.directoryFactory, this.folderLayout.getFolder(indexId), this.failureStorage, indexId, descriptor);
        }
        return new NonUniqueLuceneIndexPopulator(10000, this.documentStructure, IndexWriterFactories.tracking(), this.writerStatus, this.directoryFactory, this.folderLayout.getFolder(indexId), this.failureStorage, indexId);
    }

    public IndexAccessor getOnlineAccessor(long indexId, IndexConfiguration config) throws IOException {
        if (config.isUnique()) {
            return new UniqueLuceneIndexAccessor(this.documentStructure, IndexWriterFactories.reserving(), this.writerStatus, this.directoryFactory, this.folderLayout.getFolder(indexId));
        }
        return new NonUniqueLuceneIndexAccessor(this.documentStructure, IndexWriterFactories.reserving(), this.writerStatus, this.directoryFactory, this.folderLayout.getFolder(indexId));
    }

    public void shutdown() throws Throwable {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InternalIndexState getInitialState(long indexId) {
        try {
            String failure = this.failureStorage.loadIndexFailure(indexId);
            if (failure != null) {
                this.failures.put(indexId, failure);
                return InternalIndexState.FAILED;
            }
            try (Directory directory = this.directoryFactory.open(this.folderLayout.getFolder(indexId));){
                boolean status = this.writerStatus.isOnline(directory);
                InternalIndexState internalIndexState = status ? InternalIndexState.ONLINE : InternalIndexState.POPULATING;
                return internalIndexState;
            }
        }
        catch (CorruptIndexException e) {
            return InternalIndexState.FAILED;
        }
        catch (FileNotFoundException e) {
            this.failures.put(indexId, "File not found: " + e.getMessage());
            return InternalIndexState.FAILED;
        }
        catch (EOFException e) {
            this.failures.put(indexId, "EOF encountered: " + e.getMessage());
            return InternalIndexState.FAILED;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getPopulationFailure(long indexId) throws IllegalStateException {
        String failure = this.failureStorage.loadIndexFailure(indexId);
        if (failure == null) {
            failure = this.failures.get(indexId);
        }
        if (failure == null) {
            throw new IllegalStateException("Index " + indexId + " isn't failed");
        }
        return failure;
    }
}

