/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.api.direct.BoundedIterable;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.DirectorySupport;
import org.neo4j.kernel.api.impl.index.IndexWriterFactory;
import org.neo4j.kernel.api.impl.index.IndexWriterStatus;
import org.neo4j.kernel.api.impl.index.LuceneAllDocumentsReader;
import org.neo4j.kernel.api.impl.index.LuceneAllEntriesIndexAccessorReader;
import org.neo4j.kernel.api.impl.index.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.index.LuceneIndexAccessorReader;
import org.neo4j.kernel.api.impl.index.LuceneSnapshotter;
import org.neo4j.kernel.api.impl.index.ReservingLuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.Reservation;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.UpdateMode;

abstract class LuceneIndexAccessor
implements IndexAccessor {
    protected final LuceneDocumentStructure documentStructure;
    protected final SearcherManager searcherManager;
    protected final ReservingLuceneIndexWriter writer;
    private final IndexWriterStatus writerStatus;
    private final Directory dir;
    private final File dirFile;

    LuceneIndexAccessor(LuceneDocumentStructure documentStructure, IndexWriterFactory<ReservingLuceneIndexWriter> indexWriterFactory, IndexWriterStatus writerStatus, DirectoryFactory dirFactory, File dirFile) throws IOException {
        this.documentStructure = documentStructure;
        this.dirFile = dirFile;
        this.dir = dirFactory.open(dirFile);
        this.writer = indexWriterFactory.create(this.dir);
        this.writerStatus = writerStatus;
        this.searcherManager = this.writer.createSearcherManager();
    }

    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        switch (mode) {
            case ONLINE: {
                return new LuceneIndexUpdater(false);
            }
            case RECOVERY: {
                return new LuceneIndexUpdater(true);
            }
        }
        throw new ThisShouldNotHappenError("Stefan", "Unsupported update mode");
    }

    public void drop() throws IOException {
        this.closeIndexResources();
        DirectorySupport.deleteDirectoryContents(this.dir);
    }

    public void force() throws IOException {
        this.writerStatus.commitAsOnline(this.writer);
    }

    public void close() throws IOException {
        this.closeIndexResources();
        this.dir.close();
    }

    private void closeIndexResources() throws IOException {
        this.writerStatus.close(this.writer);
        this.searcherManager.close();
    }

    public IndexReader newReader() {
        return new LuceneIndexAccessorReader(this.searcherManager, this.documentStructure);
    }

    public BoundedIterable<Long> newAllEntriesReader() {
        return new LuceneAllEntriesIndexAccessorReader(new LuceneAllDocumentsReader((ReferenceManager<IndexSearcher>)this.searcherManager), this.documentStructure);
    }

    public ResourceIterator<File> snapshotFiles() throws IOException {
        return new LuceneSnapshotter().snapshot(this.dirFile, this.writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecovered(long nodeId, Object value) throws IOException, IndexCapacityExceededException {
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            TopDocs hits = searcher.search((Query)new TermQuery(this.documentStructure.newQueryForChangeOrRemove(nodeId)), 1);
            if (hits.totalHits > 0) {
                this.writer.updateDocument(this.documentStructure.newQueryForChangeOrRemove(nodeId), this.documentStructure.newDocumentRepresentingProperty(nodeId, value));
            } else {
                this.add(nodeId, value);
            }
        }
        finally {
            this.searcherManager.release((Object)searcher);
        }
    }

    protected void add(long nodeId, Object value) throws IOException, IndexCapacityExceededException {
        this.writer.addDocument(this.documentStructure.newDocumentRepresentingProperty(nodeId, value));
    }

    protected void change(long nodeId, Object valueAfter) throws IOException, IndexCapacityExceededException {
        this.writer.updateDocument(this.documentStructure.newQueryForChangeOrRemove(nodeId), this.documentStructure.newDocumentRepresentingProperty(nodeId, valueAfter));
    }

    protected void remove(long nodeId) throws IOException {
        this.writer.deleteDocuments(this.documentStructure.newQueryForChangeOrRemove(nodeId));
    }

    private synchronized void refreshSearcherManager() throws IOException {
        this.searcherManager.maybeRefresh();
    }

    private class LuceneIndexUpdater
    implements IndexUpdater {
        private final boolean inRecovery;

        private LuceneIndexUpdater(boolean inRecovery) {
            this.inRecovery = inRecovery;
        }

        public Reservation validate(Iterable<NodePropertyUpdate> updates) throws IOException, IndexCapacityExceededException {
            int insertionsCount = 0;
            for (NodePropertyUpdate update : updates) {
                if (update.getUpdateMode() != UpdateMode.ADDED && update.getUpdateMode() != UpdateMode.CHANGED) continue;
                ++insertionsCount;
            }
            LuceneIndexAccessor.this.writer.reserveInsertions(insertionsCount);
            final int insertions = insertionsCount;
            return new Reservation(){
                boolean released;

                public void release() {
                    if (this.released) {
                        throw new IllegalStateException("Reservation was already released. Previously reserved " + insertions + " insertions");
                    }
                    LuceneIndexAccessor.this.writer.removeReservedInsertions(insertions);
                    this.released = true;
                }
            };
        }

        public void process(NodePropertyUpdate update) throws IOException, IndexCapacityExceededException {
            switch (update.getUpdateMode()) {
                case ADDED: {
                    if (this.inRecovery) {
                        LuceneIndexAccessor.this.addRecovered(update.getNodeId(), update.getValueAfter());
                        break;
                    }
                    LuceneIndexAccessor.this.add(update.getNodeId(), update.getValueAfter());
                    break;
                }
                case CHANGED: {
                    LuceneIndexAccessor.this.change(update.getNodeId(), update.getValueAfter());
                    break;
                }
                case REMOVED: {
                    LuceneIndexAccessor.this.remove(update.getNodeId());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        public synchronized void close() throws IOException, IndexEntryConflictException {
            LuceneIndexAccessor.this.refreshSearcherManager();
        }

        public void remove(Iterable<Long> nodeIds) throws IOException {
            for (long nodeId : nodeIds) {
                LuceneIndexAccessor.this.remove(nodeId);
            }
        }
    }
}

