/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.neo4j.kernel.api.impl.index.bitmaps.Bitmap;
import org.neo4j.kernel.api.impl.index.bitmaps.BitmapFormat;

public enum BitmapDocumentFormat {
    _32(BitmapFormat._32){

        @Override
        protected NumericField setFieldValue(NumericField field, long bitmap) {
            assert ((bitmap & 0xFFFFFFFF00000000L) == 0L) : "Tried to store a bitmap as int, but which had values outside int limits";
            return field.setIntValue((int)bitmap);
        }
    }
    ,
    _64(BitmapFormat._64){

        @Override
        protected NumericField setFieldValue(NumericField field, long bitmap) {
            return field.setLongValue(bitmap);
        }
    };

    public static final String RANGE = "range";
    public static final String LABEL = "label";
    private final BitmapFormat format;

    private BitmapDocumentFormat(BitmapFormat format) {
        this.format = format;
    }

    public String toString() {
        return String.format("%s{%s bit}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.format});
    }

    public BitmapFormat bitmapFormat() {
        return this.format;
    }

    public long rangeOf(Document doc) {
        return Long.parseLong(doc.get(RANGE));
    }

    public long rangeOf(Fieldable field) {
        return Long.parseLong(field.stringValue());
    }

    public long mapOf(Document doc, long labelId) {
        return this.bitmap(doc.getFieldable(this.label(labelId)));
    }

    public Query labelQuery(long labelId) {
        return new TermQuery(new Term(LABEL, Long.toString(labelId)));
    }

    public Query rangeQuery(long range) {
        return new TermQuery(new Term(RANGE, Long.toString(range)));
    }

    public Fieldable rangeField(long range) {
        Field field = new Field(RANGE, Long.toString(range), Field.Store.YES, Field.Index.NOT_ANALYZED);
        field.setOmitNorms(true);
        field.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
        return field;
    }

    public Fieldable labelField(long key, long bitmap) {
        NumericField field = new NumericField(this.label(key), Field.Store.YES, false);
        field = this.setFieldValue(field, bitmap);
        field.setOmitNorms(true);
        field.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
        return field;
    }

    protected abstract NumericField setFieldValue(NumericField var1, long var2);

    public void addLabelField(Document document, long label, Bitmap bitmap) {
        document.add(this.labelField(label, bitmap));
        document.add(this.labelSearchField(label));
    }

    public Fieldable labelSearchField(long label) {
        Field field = new Field(LABEL, Long.toString(label), Field.Store.NO, Field.Index.NOT_ANALYZED);
        field.setOmitNorms(true);
        field.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
        return field;
    }

    public Fieldable labelField(long key, Bitmap value) {
        return this.labelField(key, value.bitmap());
    }

    String label(long key) {
        return Long.toString(key);
    }

    public long labelId(Fieldable field) {
        return Long.parseLong(field.name());
    }

    public Term rangeTerm(long range) {
        return new Term(RANGE, Long.toString(range));
    }

    public Term rangeTerm(Document document) {
        return new Term(RANGE, document.get(RANGE));
    }

    public boolean isRangeField(Fieldable field) {
        String fieldName = field.name();
        return RANGE.equals(fieldName) || LABEL.equals(fieldName);
    }

    public Bitmap readBitmap(Fieldable field) {
        return new Bitmap(this.bitmap(field));
    }

    private long bitmap(Fieldable field) {
        if (field == null) {
            return 0L;
        }
        if (field instanceof NumericField) {
            return ((NumericField)field).getNumericValue().longValue();
        }
        throw new IllegalArgumentException(field + " is not a numeric field");
    }
}

