/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.Vector;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.Weight;
import org.neo4j.index.impl.lucene.HitDoc;
import org.neo4j.index.impl.lucene.LuceneDataSource;

public final class Hits {
    private static int MAX_CACHED_DOCS = 200;
    private Weight weight;
    private IndexSearcher searcher;
    private Filter filter = null;
    private Sort sort = null;
    private int length;
    private Vector<HitDoc> hitDocs = new Vector();
    private HitDoc first;
    private HitDoc last;
    private int numDocs = 0;
    private int nDeletions;
    private int lengthAtStart;
    private int nDeletedHits = 0;
    boolean debugCheckedForDeletions = false;
    private boolean score;

    public Hits(IndexSearcher s, Query q, Filter f) throws IOException {
        this.score = false;
        this.weight = q.weight((Searcher)s);
        this.searcher = s;
        this.filter = f;
        this.nDeletions = this.countDeletions(s);
        this.getMoreDocs(50);
        this.lengthAtStart = this.length;
    }

    public Hits(IndexSearcher s, Query q, Filter f, Sort o, boolean score) throws IOException {
        this.score = score;
        this.weight = q.weight((Searcher)s);
        this.searcher = s;
        this.filter = f;
        this.sort = o;
        this.nDeletions = this.countDeletions(s);
        this.getMoreDocs(50);
        this.lengthAtStart = this.length;
    }

    private int countDeletions(IndexSearcher s) throws IOException {
        int cnt = -1;
        if (s instanceof IndexSearcher) {
            cnt = s.maxDoc() - s.getIndexReader().numDocs();
        }
        return cnt;
    }

    private void getMoreDocs(int min) throws IOException {
        if (this.hitDocs.size() > min) {
            min = this.hitDocs.size();
        }
        int n = min * 2;
        TopDocs topDocs = null;
        if (this.sort == null) {
            topDocs = this.searcher.search(this.weight, this.filter, n);
        } else if (this.score) {
            TopFieldCollector collector = LuceneDataSource.scoringCollector(this.sort, n);
            this.searcher.search(this.weight, null, (Collector)collector);
            topDocs = collector.topDocs();
        } else {
            topDocs = this.searcher.search(this.weight, this.filter, n, this.sort);
        }
        this.length = topDocs.totalHits;
        ScoreDoc[] scoreDocs = topDocs.scoreDocs;
        float scoreNorm = 1.0f;
        if (this.length > 0 && topDocs.getMaxScore() > 1.0f) {
            scoreNorm = 1.0f / topDocs.getMaxScore();
        }
        int start = this.hitDocs.size() - this.nDeletedHits;
        int nDels2 = this.countDeletions(this.searcher);
        this.debugCheckedForDeletions = false;
        if (this.nDeletions < 0 || nDels2 > this.nDeletions) {
            this.nDeletedHits = 0;
            this.debugCheckedForDeletions = true;
            int i2 = 0;
            for (int i1 = 0; i1 < this.hitDocs.size() && i2 < scoreDocs.length; ++i1) {
                int id1 = this.hitDocs.get((int)i1).id;
                int id2 = scoreDocs[i2].doc;
                if (id1 == id2) {
                    ++i2;
                    continue;
                }
                ++this.nDeletedHits;
            }
            start = i2;
        }
        int end = scoreDocs.length < this.length ? scoreDocs.length : this.length;
        this.length += this.nDeletedHits;
        for (int i = start; i < end; ++i) {
            this.hitDocs.addElement(new HitDoc(scoreDocs[i].score * scoreNorm, scoreDocs[i].doc));
        }
        this.nDeletions = nDels2;
    }

    public int length() {
        return this.length;
    }

    public Document doc(int n) throws CorruptIndexException, IOException {
        HitDoc hitDoc = this.hitDoc(n);
        this.remove(hitDoc);
        this.addToFront(hitDoc);
        if (this.numDocs > MAX_CACHED_DOCS) {
            HitDoc oldLast = this.last;
            this.remove(this.last);
            oldLast.doc = null;
        }
        if (hitDoc.doc == null) {
            hitDoc.doc = this.searcher.doc(hitDoc.id);
        }
        return hitDoc.doc;
    }

    public float score(int n) throws IOException {
        return this.hitDoc((int)n).score;
    }

    public int id(int n) throws IOException {
        return this.hitDoc((int)n).id;
    }

    private HitDoc hitDoc(int n) throws IOException {
        if (n >= this.lengthAtStart) {
            throw new IndexOutOfBoundsException("Not a valid hit number: " + n);
        }
        if (n >= this.hitDocs.size()) {
            this.getMoreDocs(n);
        }
        if (n >= this.length) {
            throw new ConcurrentModificationException("Not a valid hit number: " + n);
        }
        return this.hitDocs.elementAt(n);
    }

    private void addToFront(HitDoc hitDoc) {
        if (this.first == null) {
            this.last = hitDoc;
        } else {
            this.first.prev = hitDoc;
        }
        hitDoc.next = this.first;
        this.first = hitDoc;
        hitDoc.prev = null;
        ++this.numDocs;
    }

    private void remove(HitDoc hitDoc) {
        if (hitDoc.doc == null) {
            return;
        }
        if (hitDoc.next == null) {
            this.last = hitDoc.prev;
        } else {
            hitDoc.next.prev = hitDoc.prev;
        }
        if (hitDoc.prev == null) {
            this.first = hitDoc.next;
        } else {
            hitDoc.prev.next = hitDoc.next;
        }
        --this.numDocs;
    }
}

