/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.File;
import java.io.IOException;
import java.util.TimeZone;
import org.neo4j.helpers.Args;
import org.neo4j.index.impl.lucene.LuceneDataSource;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReaderFactory;
import org.neo4j.kernel.impl.util.DumpLogicalLog;

public class DumpLogicalLog
extends org.neo4j.kernel.impl.util.DumpLogicalLog {
    public DumpLogicalLog(FileSystemAbstraction fileSystem) {
        super(fileSystem);
    }

    public static void main(String[] args) throws IOException {
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        Args arguments = new Args(args);
        TimeZone timeZome = DumpLogicalLog.parseTimeZoneConfig((Args)arguments);
        try (DumpLogicalLog.Printer printer = DumpLogicalLog.getPrinter((Args)arguments);){
            for (String file : arguments.orphans()) {
                int dumped = new DumpLogicalLog((FileSystemAbstraction)fs).dump(file, printer.getFor(file), timeZome);
                if (dumped != 0 || !DumpLogicalLog.isAGraphDatabaseDirectory((String)file)) continue;
                new DumpLogicalLog((FileSystemAbstraction)fs).dump(new File(file, "index").getAbsolutePath(), printer.getFor(file), timeZome);
            }
        }
    }

    protected XaCommandReaderFactory instantiateCommandReaderFactory() {
        return new LuceneDataSource.LuceneCommandReaderFactory(null, null);
    }

    protected String getLogPrefix() {
        return "lucene.log";
    }
}

