/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.log4j;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.OutputStreamAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.layout.template.json.JsonTemplateLayout;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.status.StatusLogger;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.Level;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.logging.log4j.AbstractLookup;
import org.neo4j.logging.log4j.LogUtils;
import org.neo4j.logging.log4j.LoggerTarget;
import org.neo4j.logging.log4j.LookupContext;
import org.neo4j.logging.log4j.Neo4jConfiguration;
import org.neo4j.logging.log4j.Neo4jDebugLogLayout;
import org.neo4j.logging.log4j.Neo4jLoggerContext;

public final class LogConfig {
    public static final String DEBUG_LOG = "debug.log";
    public static final String USER_LOG = "neo4j.log";
    public static final String QUERY_LOG = "query.log";
    public static final String SECURITY_LOG = "security.log";
    public static final String HTTP_LOG = "http.log";
    public static final String QUERY_LOG_JSON_TEMPLATE = "classpath:org/neo4j/logging/QueryLogJsonLayout.json";
    public static final String STRUCTURED_LOG_JSON_TEMPLATE = "classpath:org/neo4j/logging/StructuredJsonLayout.json";
    public static final String STRUCTURED_LOG_JSON_TEMPLATE_WITH_CATEGORY = "classpath:org/neo4j/logging/StructuredLayoutWithCategory.json";
    public static final String STRUCTURED_LOG_JSON_TEMPLATE_WITH_MESSAGE = "classpath:org/neo4j/logging/StructuredLayoutWithMessage.json";
    public static final String SERVER_LOGS_XML = "server-logs.xml";
    public static final String USER_LOGS_XML = "user-logs.xml";
    private static final Map<Path, String> KNOWN_DEFAULTS = Map.of(Path.of("server-logs.xml", new String[0]), "default-server-logs.xml", Path.of("user-logs.xml", new String[0]), "default-user-logs.xml");

    private LogConfig() {
    }

    static void updateLogLevel(Level level, Neo4jLoggerContext context) {
        LoggerContext log4jContext = (LoggerContext)context.getLoggerContext();
        Configuration config = log4jContext.getConfiguration();
        LoggerConfig loggerConfig = config.getRootLogger();
        loggerConfig.setLevel(LogConfig.convertNeo4jLevelToLevel(level));
        log4jContext.updateLoggers();
    }

    public static Neo4jLoggerContext createLoggerFromXmlConfig(FileSystemAbstraction fs, Path xmlConfigFile) {
        return LogConfig.createLoggerFromXmlConfig(fs, xmlConfigFile, false, null);
    }

    public static Neo4jLoggerContext createLoggerFromXmlConfig(FileSystemAbstraction fs, Path xmlConfigFile, boolean useDefaultOnMissingXml, Function<String, Object> configLookup) {
        return LogConfig.createLoggerFromXmlConfig(fs, xmlConfigFile, useDefaultOnMissingXml, false, configLookup, null, null);
    }

    public static Neo4jLoggerContext createLoggerFromXmlConfig(FileSystemAbstraction fs, Path xmlConfigFile, boolean useDefaultOnMissingXml, boolean daemonMode, Function<String, Object> configLookup, Consumer<InternalLog> headerLogger, String headerClassName) {
        return new Builder(fs, xmlConfigFile).withConfigLookup(configLookup).withHeaderLogger(headerLogger, headerClassName).withUseDefaultOnMissingXml(useDefaultOnMissingXml).withDaemonMode(daemonMode).build();
    }

    public static Neo4jLoggerContext createTemporaryLoggerToSingleFile(FileSystemAbstraction fs, Path logPath, Level level, boolean withCategory) {
        Path xmlConfig = LogUtils.newTemporaryXmlConfigBuilder(fs).withLogger(LogUtils.newLoggerBuilder(LoggerTarget.ROOT_LOGGER, logPath).withLevel(LogConfig.convertNeo4jLevelToLevel(level).toString()).withCategory(withCategory).build()).create();
        return new Builder(fs, xmlConfig).build();
    }

    public static Builder createBuilderToOutputStream(OutputStream outputStream, Level level) {
        return new Builder(outputStream, level);
    }

    static org.apache.logging.log4j.Level convertNeo4jLevelToLevel(Level level) {
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case Level.ERROR -> org.apache.logging.log4j.Level.ERROR;
            case Level.WARN -> org.apache.logging.log4j.Level.WARN;
            case Level.INFO -> org.apache.logging.log4j.Level.INFO;
            case Level.DEBUG -> org.apache.logging.log4j.Level.DEBUG;
            case Level.NONE -> org.apache.logging.log4j.Level.OFF;
        };
    }

    public static String getFormatPattern(boolean includeCategory, LogTimeZone timezone) {
        String date = "%d{yyyy-MM-dd HH:mm:ss.SSSZ}" + (timezone == LogTimeZone.UTC ? "{GMT+0}" : "");
        return includeCategory ? date + " %-5p [%c{1.}] %m%n" : date + " %-5p %m%n";
    }

    private static void configureLoggingForStream(LoggerContext context, Builder builder) {
        Neo4jConfiguration configuration = new Neo4jConfiguration();
        OutputStreamAppender appender = ((OutputStreamAppender.Builder)((OutputStreamAppender.Builder)OutputStreamAppender.newBuilder().setName("neo4jLog.stream")).setTarget(builder.outputStream).setLayout((Layout)(builder.jsonLayout == null ? PatternLayout.newBuilder().withPattern(LogConfig.getFormatPattern(builder.includeCategory, LogTimeZone.UTC)).build() : JsonTemplateLayout.newBuilder().setConfiguration((Configuration)configuration).setEventTemplateUri(builder.jsonLayout).build()))).build();
        appender.start();
        configuration.addAppender((Appender)appender);
        configuration.getRootLogger().addAppender((Appender)appender, null, null);
        configuration.getRootLogger().setLevel(builder.level);
        context.setConfiguration((Configuration)configuration);
    }

    private static void configureLoggingFromFile(LoggerContext context, Consumer<InternalLog> headerLogger, String headerClassName, Function<String, Object> configLookup, ConfigurationSource configSource, boolean daemonMode) {
        LookupContext lookupContext = new LookupContext(headerLogger, headerClassName, configLookup);
        LookupInjectionXmlConfiguration lookupInjectionXmlConfiguration = new LookupInjectionXmlConfiguration(context, configSource, lookupContext, daemonMode);
        context.setConfiguration((Configuration)lookupInjectionXmlConfiguration);
        if (daemonMode && !lookupInjectionXmlConfiguration.removedAppenders.isEmpty()) {
            ExtendedLogger logger = context.getLogger(LogConfig.class);
            logger.info("Running in daemon mode, all <Console> appenders will be suppressed:");
            lookupInjectionXmlConfiguration.removedAppenders.forEach(arg_0 -> ((ExtendedLogger)logger).info(arg_0));
        }
    }

    public static class Builder {
        private final FileSystemAbstraction fileSystemAbstraction;
        private final Path externalConfigPath;
        private final org.apache.logging.log4j.Level level;
        private final OutputStream outputStream;
        private boolean includeCategory = true;
        private Consumer<InternalLog> headerLogger;
        private String headerClassName;
        private Function<String, Object> configLookup;
        private String jsonLayout;
        private boolean useDefaultOnMissingXml = false;
        private boolean daemonMode = false;
        private String configSourceInfo = "<programmatically>";

        private Builder(FileSystemAbstraction fileSystemAbstraction, Path xmlConfigFile) {
            this.fileSystemAbstraction = fileSystemAbstraction;
            this.externalConfigPath = xmlConfigFile;
            this.outputStream = null;
            this.level = null;
        }

        private Builder(OutputStream outputStream, Level level) {
            this.outputStream = outputStream;
            this.level = LogConfig.convertNeo4jLevelToLevel(level);
            this.fileSystemAbstraction = null;
            this.externalConfigPath = null;
        }

        public Builder withConfigLookup(Function<String, Object> configLookup) {
            this.configLookup = configLookup;
            return this;
        }

        public Builder withCategory(boolean includeCategory) {
            this.includeCategory = includeCategory;
            return this;
        }

        public Builder withHeaderLogger(Consumer<InternalLog> headerLogger, String headerClassName) {
            this.headerLogger = headerLogger;
            this.headerClassName = headerClassName;
            return this;
        }

        public Builder withJsonLayout(String jsonLayout) {
            this.jsonLayout = jsonLayout;
            return this;
        }

        public Builder withUseDefaultOnMissingXml(boolean useDefaultOnMissingXml) {
            this.useDefaultOnMissingXml = useDefaultOnMissingXml;
            return this;
        }

        public Builder withDaemonMode(boolean daemonMode) {
            this.daemonMode = daemonMode;
            return this;
        }

        public Neo4jLoggerContext build() {
            LoggerContext context = new LoggerContext("LoggerContext");
            if (this.outputStream != null) {
                LogConfig.configureLoggingForStream(context, this);
            } else {
                try {
                    ConfigurationSource configurationSource = this.getConfigurationSource();
                    LogConfig.configureLoggingFromFile(context, this.headerLogger, this.headerClassName, this.configLookup, configurationSource, this.daemonMode);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return new Neo4jLoggerContext((org.apache.logging.log4j.spi.LoggerContext)context, null, this.configSourceInfo);
        }

        private ConfigurationSource getConfigurationSource() throws IOException {
            String defaultResourcePath;
            ConfigurationSource configurationSource = null;
            if (this.fileSystemAbstraction.fileExists(this.externalConfigPath)) {
                if (this.fileSystemAbstraction.isPersistent()) {
                    configurationSource = ConfigurationSource.fromUri((URI)this.externalConfigPath.toUri());
                    this.configSourceInfo = "File '%s'".formatted(this.externalConfigPath.toAbsolutePath());
                } else {
                    configurationSource = new ConfigurationSource(this.fileSystemAbstraction.openAsInputStream(this.externalConfigPath));
                }
            } else if (this.useDefaultOnMissingXml && (defaultResourcePath = KNOWN_DEFAULTS.get(this.externalConfigPath.getFileName())) != null) {
                configurationSource = ConfigurationSource.fromResource((String)defaultResourcePath, (ClassLoader)this.getClass().getClassLoader());
                this.configSourceInfo = "Embedded default config '%s'".formatted(defaultResourcePath);
            }
            if (configurationSource == null) {
                throw new IllegalStateException("Missing xml file for " + String.valueOf(this.externalConfigPath));
            }
            return configurationSource;
        }
    }

    private static class LookupInjectionXmlConfiguration
    extends XmlConfiguration {
        private final LookupContext context;
        private final boolean daemonMode;
        private final List<String> removedAppenders = new ArrayList<String>();

        LookupInjectionXmlConfiguration(LoggerContext loggerContext, ConfigurationSource configSource, LookupContext context, boolean daemonMode) {
            super(loggerContext, configSource);
            this.context = context;
            this.daemonMode = daemonMode;
        }

        protected void doConfigure() {
            AbstractLookup.setLookupContext(this.context);
            super.doConfigure();
            AbstractLookup.removeLookupContext();
            if (this.daemonMode) {
                List<ConsoleAppender> consoleAppenders = this.getAppenders().values().stream().filter(ConsoleAppender.class::isInstance).map(ConsoleAppender.class::cast).toList();
                for (ConsoleAppender consoleAppender : consoleAppenders) {
                    this.removedAppenders.add("Removing console appender '" + consoleAppender.getName() + "' with target '" + String.valueOf(consoleAppender.getTarget()) + "'.");
                    this.removeAppender(consoleAppender.getName());
                }
            }
            for (Appender appender : this.getAppenders().values()) {
                Layout layout = appender.getLayout();
                if (!(layout instanceof Neo4jDebugLogLayout)) continue;
                Neo4jDebugLogLayout neo4jDebugLogLayout = (Neo4jDebugLogLayout)layout;
                neo4jDebugLogLayout.setHeaderLogger(this.context.headerLogger(), this.context.headerClassName());
            }
        }

        public Configuration reconfigure() {
            try {
                ConfigurationSource source = this.getConfigurationSource().resetInputStream();
                if (source == null) {
                    return null;
                }
                return new LookupInjectionXmlConfiguration(this.getLoggerContext(), source, this.context, this.daemonMode);
            }
            catch (IOException ex) {
                StatusLogger.getLogger().error("Cannot locate file {}", (Object)this.getConfigurationSource(), (Object)ex);
                return null;
            }
        }
    }
}

