/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.internal;

import java.util.Objects;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.Neo4jLogMessage;
import org.neo4j.logging.Neo4jMessageSupplier;

public class PrefixedLog
implements InternalLog {
    private final String prefix;
    private final InternalLog delegate;

    PrefixedLog(String prefix, InternalLog delegate) {
        Objects.requireNonNull(prefix, "prefix must be a string");
        Objects.requireNonNull(delegate, "delegate log cannot be null");
        this.prefix = "[" + prefix + "] ";
        this.delegate = delegate;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    @Override
    public void debug(String message) {
        this.delegate.debug(this.withPrefix(message));
    }

    @Override
    public void debug(String message, Throwable throwable) {
        this.delegate.debug(this.withPrefix(message), throwable);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.delegate.debug(this.withPrefix(format), arguments);
    }

    @Override
    public void info(String message) {
        this.delegate.info(this.withPrefix(message));
    }

    @Override
    public void info(String message, Throwable throwable) {
        this.delegate.info(this.withPrefix(message), throwable);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.delegate.info(this.withPrefix(format), arguments);
    }

    @Override
    public void warn(String message) {
        this.delegate.warn(this.withPrefix(message));
    }

    @Override
    public void warn(String message, Throwable throwable) {
        this.delegate.warn(this.withPrefix(message), throwable);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.delegate.warn(this.withPrefix(format), arguments);
    }

    @Override
    public void error(String message) {
        this.delegate.error(this.withPrefix(message));
    }

    @Override
    public void error(String message, Throwable throwable) {
        this.delegate.error(this.withPrefix(message), throwable);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.delegate.error(this.withPrefix(format), arguments);
    }

    @Override
    public void debug(Neo4jLogMessage message) {
    }

    @Override
    public void debug(Neo4jMessageSupplier supplier) {
    }

    @Override
    public void info(Neo4jLogMessage message) {
    }

    @Override
    public void info(Neo4jMessageSupplier supplier) {
    }

    @Override
    public void warn(Neo4jLogMessage message) {
    }

    @Override
    public void warn(Neo4jMessageSupplier supplier) {
    }

    @Override
    public void error(Neo4jLogMessage message) {
    }

    @Override
    public void error(Neo4jMessageSupplier supplier) {
    }

    @Override
    public void error(Neo4jLogMessage message, Throwable throwable) {
    }

    private String withPrefix(String message) {
        return this.prefix + message;
    }
}

