/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.internal;

import java.util.Objects;
import java.util.function.Consumer;
import org.neo4j.logging.AbstractLog;
import org.neo4j.logging.Log;

public class PrefixedLog
extends AbstractLog {
    private final String prefix;
    private final Log delegate;

    PrefixedLog(String prefix, Log delegate) {
        Objects.requireNonNull(prefix, "prefix must be a string");
        Objects.requireNonNull(delegate, "delegate log cannot be null");
        this.prefix = "[" + prefix + "] ";
        this.delegate = delegate;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    @Override
    public void debug(String message) {
        this.delegate.debug(this.withPrefix(message));
    }

    @Override
    public void debug(String message, Throwable throwable) {
        this.delegate.debug(this.withPrefix(message), throwable);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.delegate.debug(this.withPrefix(format), arguments);
    }

    @Override
    public void info(String message) {
        this.delegate.info(this.withPrefix(message));
    }

    @Override
    public void info(String message, Throwable throwable) {
        this.delegate.info(this.withPrefix(message), throwable);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.delegate.info(this.withPrefix(format), arguments);
    }

    @Override
    public void warn(String message) {
        this.delegate.warn(this.withPrefix(message));
    }

    @Override
    public void warn(String message, Throwable throwable) {
        this.delegate.warn(this.withPrefix(message), throwable);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.delegate.warn(this.withPrefix(format), arguments);
    }

    @Override
    public void error(String message) {
        this.delegate.error(this.withPrefix(message));
    }

    @Override
    public void error(String message, Throwable throwable) {
        this.delegate.error(this.withPrefix(message), throwable);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.delegate.error(this.withPrefix(format), arguments);
    }

    @Override
    @Deprecated
    public void bulk(Consumer<Log> consumer) {
        this.delegate.bulk(log -> consumer.accept(this));
    }

    private String withPrefix(String message) {
        return this.prefix + message;
    }
}

