/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.neo4j.logging.AbstractLog;
import org.neo4j.logging.Log;

public class DuplicatingLog
extends AbstractLog {
    private final Log log1;
    private final Log log2;

    public DuplicatingLog(Log log1, Log log2) {
        this.log1 = log1;
        this.log2 = log2;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log1.isDebugEnabled() || this.log2.isDebugEnabled();
    }

    @Override
    public void debug(@Nonnull String message) {
        this.log1.debug(message);
        this.log2.debug(message);
    }

    @Override
    public void debug(@Nonnull String message, @Nonnull Throwable throwable) {
        this.log1.debug(message, throwable);
        this.log2.debug(message, throwable);
    }

    @Override
    public void debug(@Nonnull String format, Object ... arguments) {
        this.log1.debug(format, arguments);
        this.log2.debug(format, arguments);
    }

    @Override
    public void info(@Nonnull String message) {
        this.log1.info(message);
        this.log2.info(message);
    }

    @Override
    public void info(@Nonnull String message, @Nonnull Throwable throwable) {
        this.log1.info(message, throwable);
        this.log2.info(message, throwable);
    }

    @Override
    public void info(@Nonnull String format, Object ... arguments) {
        this.log1.info(format, arguments);
        this.log2.info(format, arguments);
    }

    @Override
    public void warn(@Nonnull String message) {
        this.log1.warn(message);
        this.log2.warn(message);
    }

    @Override
    public void warn(@Nonnull String message, @Nonnull Throwable throwable) {
        this.log1.warn(message, throwable);
        this.log2.warn(message, throwable);
    }

    @Override
    public void warn(@Nonnull String format, Object ... arguments) {
        this.log1.warn(format, arguments);
        this.log2.warn(format, arguments);
    }

    @Override
    public void error(@Nonnull String message) {
        this.log1.error(message);
        this.log2.error(message);
    }

    @Override
    public void error(@Nonnull String message, @Nonnull Throwable throwable) {
        this.log1.error(message, throwable);
        this.log2.error(message, throwable);
    }

    @Override
    public void error(@Nonnull String format, Object ... arguments) {
        this.log1.error(format, arguments);
        this.log2.error(format, arguments);
    }

    @Override
    public void bulk(@Nonnull Consumer<Log> consumer) {
        consumer.accept(this);
    }
}

